%------------------------------------------------------------------------------
% File     : ITP021^5 : TPTP v9.2.0. Bugfixed v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : HOL4 set theory export of thm_2Eextreal_2Emax__le.p, chainy mode
% Version  : [BG+19] axioms.
% English  :

% Refs     : [BG+19] Brown et al. (2019), GRUNGE: A Grand Unified ATP Chall
%          : [Gau20] Gauthier (2020), Email to Geoff Sutcliffe
% Source   : [BG+19]
% Names    : thm_2Eextreal_2Emax__le.p [Gau20]
%          : HL410001^5.p [TPAP]

% Status   : Theorem
% Rating   : 0.78 v9.1.0, 0.88 v9.0.0, 0.90 v8.2.0, 0.92 v8.1.0, 1.00 v7.5.0
% Syntax   : Number of formulae    : 19591 (2642 unt;3187 typ;   0 def)
%            Number of atoms       : 437456 (17903 equ;   0 cnn)
%            Maximal formula atoms : 9395 (  26 avg)
%            Number of connectives : 820166 (2527   ~;1056   |;25890   &;752121   @)
%                                         (6164 <=>;32408  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  368 (  11 avg)
%            Number of types       :  148 ( 146 usr)
%            Number of type conns  : 2820 (2820   >;   0   *;   0   +;   0  <<)
%            Number of symbols     : 3125 (3122 usr;1130 con; 0-6 aty)
%            Number of variables   : 72246 (4518   ^;53829   !;13899   ?;72246   :)
% SPC      : TH0_THM_EQU_NAR

% Comments :
% Bugfixes : v7.5.0 - Bugfixes in axioms and export.
%------------------------------------------------------------------------------
include('Axioms/ITP001/ITP001^2.ax').
include('Axioms/ITP001/ITP002^5.ax').
include('Axioms/ITP001/ITP003^5.ax').
include('Axioms/ITP001/ITP004^5.ax').
include('Axioms/ITP001/ITP007^5.ax').
include('Axioms/ITP001/ITP006^5.ax').
include('Axioms/ITP001/ITP005^5.ax').
include('Axioms/ITP001/ITP008^5.ax').
include('Axioms/ITP001/ITP009^5.ax').
include('Axioms/ITP001/ITP010^5.ax').
include('Axioms/ITP001/ITP012^5.ax').
include('Axioms/ITP001/ITP011^5.ax').
include('Axioms/ITP001/ITP013^5.ax').
include('Axioms/ITP001/ITP014^5.ax').
include('Axioms/ITP001/ITP015^5.ax').
include('Axioms/ITP001/ITP017^5.ax').
include('Axioms/ITP001/ITP016^5.ax').
include('Axioms/ITP001/ITP019^5.ax').
include('Axioms/ITP001/ITP018^5.ax').
include('Axioms/ITP001/ITP021^5.ax').
include('Axioms/ITP001/ITP022^5.ax').
include('Axioms/ITP001/ITP020^5.ax').
include('Axioms/ITP001/ITP024^5.ax').
include('Axioms/ITP001/ITP023^5.ax').
include('Axioms/ITP001/ITP025^5.ax').
include('Axioms/ITP001/ITP026^5.ax').
include('Axioms/ITP001/ITP027^5.ax').
include('Axioms/ITP001/ITP028^5.ax').
include('Axioms/ITP001/ITP031^5.ax').
include('Axioms/ITP001/ITP029^5.ax').
include('Axioms/ITP001/ITP033^5.ax').
include('Axioms/ITP001/ITP030^5.ax').
include('Axioms/ITP001/ITP032^5.ax').
include('Axioms/ITP001/ITP038^5.ax').
include('Axioms/ITP001/ITP035^5.ax').
include('Axioms/ITP001/ITP034^5.ax').
include('Axioms/ITP001/ITP036^5.ax').
include('Axioms/ITP001/ITP037^5.ax').
include('Axioms/ITP001/ITP039^5.ax').
include('Axioms/ITP001/ITP041^5.ax').
include('Axioms/ITP001/ITP042^5.ax').
include('Axioms/ITP001/ITP040^5.ax').
include('Axioms/ITP001/ITP044^5.ax').
include('Axioms/ITP001/ITP051^5.ax').
include('Axioms/ITP001/ITP045^5.ax').
include('Axioms/ITP001/ITP056^5.ax').
include('Axioms/ITP001/ITP046^5.ax').
include('Axioms/ITP001/ITP043^5.ax').
include('Axioms/ITP001/ITP052^5.ax').
include('Axioms/ITP001/ITP057^5.ax').
include('Axioms/ITP001/ITP048^5.ax').
include('Axioms/ITP001/ITP047^5.ax').
include('Axioms/ITP001/ITP055^5.ax').
include('Axioms/ITP001/ITP053^5.ax').
include('Axioms/ITP001/ITP054^5.ax').
include('Axioms/ITP001/ITP058^5.ax').
include('Axioms/ITP001/ITP049^5.ax').
include('Axioms/ITP001/ITP050^5.ax').
include('Axioms/ITP001/ITP061^5.ax').
include('Axioms/ITP001/ITP069^5.ax').
include('Axioms/ITP001/ITP062^5.ax').
include('Axioms/ITP001/ITP068^5.ax').
include('Axioms/ITP001/ITP078^5.ax').
include('Axioms/ITP001/ITP064^5.ax').
include('Axioms/ITP001/ITP060^5.ax').
include('Axioms/ITP001/ITP067^5.ax').
include('Axioms/ITP001/ITP075^5.ax').
include('Axioms/ITP001/ITP074^5.ax').
include('Axioms/ITP001/ITP063^5.ax').
include('Axioms/ITP001/ITP059^5.ax').
include('Axioms/ITP001/ITP065^5.ax').
include('Axioms/ITP001/ITP076^5.ax').
include('Axioms/ITP001/ITP066^5.ax').
include('Axioms/ITP001/ITP077^5.ax').
include('Axioms/ITP001/ITP070^5.ax').
include('Axioms/ITP001/ITP071^5.ax').
include('Axioms/ITP001/ITP072^5.ax').
include('Axioms/ITP001/ITP073^5.ax').
include('Axioms/ITP001/ITP080^5.ax').
include('Axioms/ITP001/ITP083^5.ax').
include('Axioms/ITP001/ITP088^5.ax').
include('Axioms/ITP001/ITP082^5.ax').
include('Axioms/ITP001/ITP081^5.ax').
include('Axioms/ITP001/ITP079^5.ax').
include('Axioms/ITP001/ITP087^5.ax').
include('Axioms/ITP001/ITP085^5.ax').
include('Axioms/ITP001/ITP086^5.ax').
include('Axioms/ITP001/ITP090^5.ax').
include('Axioms/ITP001/ITP089^5.ax').
include('Axioms/ITP001/ITP084^5.ax').
include('Axioms/ITP001/ITP104^5.ax').
include('Axioms/ITP001/ITP097^5.ax').
include('Axioms/ITP001/ITP094^5.ax').
include('Axioms/ITP001/ITP095^5.ax').
include('Axioms/ITP001/ITP093^5.ax').
include('Axioms/ITP001/ITP102^5.ax').
include('Axioms/ITP001/ITP091^5.ax').
include('Axioms/ITP001/ITP098^5.ax').
include('Axioms/ITP001/ITP096^5.ax').
include('Axioms/ITP001/ITP100^5.ax').
include('Axioms/ITP001/ITP092^5.ax').
include('Axioms/ITP001/ITP105^5.ax').
include('Axioms/ITP001/ITP101^5.ax').
include('Axioms/ITP001/ITP103^5.ax').
include('Axioms/ITP001/ITP099^5.ax').
include('Axioms/ITP001/ITP111^5.ax').
include('Axioms/ITP001/ITP108^5.ax').
include('Axioms/ITP001/ITP106^5.ax').
include('Axioms/ITP001/ITP107^5.ax').
include('Axioms/ITP001/ITP114^5.ax').
include('Axioms/ITP001/ITP110^5.ax').
include('Axioms/ITP001/ITP109^5.ax').
include('Axioms/ITP001/ITP112^5.ax').
include('Axioms/ITP001/ITP113^5.ax').
include('Axioms/ITP001/ITP117^5.ax').
include('Axioms/ITP001/ITP116^5.ax').
include('Axioms/ITP001/ITP118^5.ax').
include('Axioms/ITP001/ITP120^5.ax').
include('Axioms/ITP001/ITP119^5.ax').
include('Axioms/ITP001/ITP121^5.ax').
include('Axioms/ITP001/ITP123^5.ax').
include('Axioms/ITP001/ITP124^5.ax').
include('Axioms/ITP001/ITP126^5.ax').
include('Axioms/ITP001/ITP127^5.ax').
include('Axioms/ITP001/ITP129^5.ax').
include('Axioms/ITP001/ITP128^5.ax').
include('Axioms/ITP001/ITP130^5.ax').
include('Axioms/ITP001/ITP131^5.ax').
include('Axioms/ITP001/ITP132^5.ax').
include('Axioms/ITP001/ITP134^5.ax').
include('Axioms/ITP001/ITP133^5.ax').
include('Axioms/ITP001/ITP135^5.ax').
include('Axioms/ITP001/ITP136^5.ax').
include('Axioms/ITP001/ITP138^5.ax').
include('Axioms/ITP001/ITP137^5.ax').
include('Axioms/ITP001/ITP140^5.ax').
include('Axioms/ITP001/ITP141^5.ax').
include('Axioms/ITP001/ITP139^5.ax').
include('Axioms/ITP001/ITP142^5.ax').
include('Axioms/ITP001/ITP145^5.ax').
include('Axioms/ITP001/ITP144^5.ax').
%------------------------------------------------------------------------------
thf(tp_ty_2Eextreal_2Eextreal,type,
    ty_2Eextreal_2Eextreal: del ).

thf(stp_ty_2Eextreal_2Eextreal,type,
    tp__ty_2Eextreal_2Eextreal: $tType ).

thf(stp_inj_ty_2Eextreal_2Eextreal,type,
    inj__ty_2Eextreal_2Eextreal: tp__ty_2Eextreal_2Eextreal > $i ).

thf(stp_surj_ty_2Eextreal_2Eextreal,type,
    surj__ty_2Eextreal_2Eextreal: $i > tp__ty_2Eextreal_2Eextreal ).

thf(stp_inj_surj_ty_2Eextreal_2Eextreal,axiom,
    ! [X: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( inj__ty_2Eextreal_2Eextreal @ X ) )
      = X ) ).

thf(stp_inj_mem_ty_2Eextreal_2Eextreal,axiom,
    ! [X: tp__ty_2Eextreal_2Eextreal] : ( mem @ ( inj__ty_2Eextreal_2Eextreal @ X ) @ ty_2Eextreal_2Eextreal ) ).

thf(stp_iso_mem_ty_2Eextreal_2Eextreal,axiom,
    ! [X: $i] :
      ( ( mem @ X @ ty_2Eextreal_2Eextreal )
     => ( X
        = ( inj__ty_2Eextreal_2Eextreal @ ( surj__ty_2Eextreal_2Eextreal @ X ) ) ) ) ).

thf(tp_c_2Eextreal_2EEXTREAL__SUM__IMAGE,type,
    c_2Eextreal_2EEXTREAL__SUM__IMAGE: del > $i ).

thf(mem_c_2Eextreal_2EEXTREAL__SUM__IMAGE,axiom,
    ! [A_27a: del] : ( mem @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ ( arr @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) @ ( arr @ ( arr @ A_27a @ bool ) @ ty_2Eextreal_2Eextreal ) ) ) ).

thf(tp_c_2Eextreal_2ENegInf,type,
    c_2Eextreal_2ENegInf: $i ).

thf(mem_c_2Eextreal_2ENegInf,axiom,
    mem @ c_2Eextreal_2ENegInf @ ty_2Eextreal_2Eextreal ).

thf(stp_fo_c_2Eextreal_2ENegInf,type,
    fo__c_2Eextreal_2ENegInf: tp__ty_2Eextreal_2Eextreal ).

thf(stp_eq_fo_c_2Eextreal_2ENegInf,axiom,
    ( ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf )
    = c_2Eextreal_2ENegInf ) ).

thf(tp_c_2Eextreal_2ENormal,type,
    c_2Eextreal_2ENormal: $i ).

thf(mem_c_2Eextreal_2ENormal,axiom,
    mem @ c_2Eextreal_2ENormal @ ( arr @ ty_2Erealax_2Ereal @ ty_2Eextreal_2Eextreal ) ).

thf(stp_fo_c_2Eextreal_2ENormal,type,
    fo__c_2Eextreal_2ENormal: tp__ty_2Erealax_2Ereal > tp__ty_2Eextreal_2Eextreal ).

thf(stp_eq_fo_c_2Eextreal_2ENormal,axiom,
    ! [X0: tp__ty_2Erealax_2Ereal] :
      ( ( inj__ty_2Eextreal_2Eextreal @ ( fo__c_2Eextreal_2ENormal @ X0 ) )
      = ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ X0 ) ) ) ).

thf(tp_c_2Eextreal_2EPosInf,type,
    c_2Eextreal_2EPosInf: $i ).

thf(mem_c_2Eextreal_2EPosInf,axiom,
    mem @ c_2Eextreal_2EPosInf @ ty_2Eextreal_2Eextreal ).

thf(stp_fo_c_2Eextreal_2EPosInf,type,
    fo__c_2Eextreal_2EPosInf: tp__ty_2Eextreal_2Eextreal ).

thf(stp_eq_fo_c_2Eextreal_2EPosInf,axiom,
    ( ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf )
    = c_2Eextreal_2EPosInf ) ).

thf(tp_c_2Eextreal_2EQ__set,type,
    c_2Eextreal_2EQ__set: $i ).

thf(mem_c_2Eextreal_2EQ__set,axiom,
    mem @ c_2Eextreal_2EQ__set @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) ).

thf(tp_c_2Eextreal_2Eceiling,type,
    c_2Eextreal_2Eceiling: $i ).

thf(mem_c_2Eextreal_2Eceiling,axiom,
    mem @ c_2Eextreal_2Eceiling @ ( arr @ ty_2Eextreal_2Eextreal @ ty_2Enum_2Enum ) ).

thf(stp_fo_c_2Eextreal_2Eceiling,type,
    fo__c_2Eextreal_2Eceiling: tp__ty_2Eextreal_2Eextreal > tp__ty_2Enum_2Enum ).

thf(stp_eq_fo_c_2Eextreal_2Eceiling,axiom,
    ! [X0: tp__ty_2Eextreal_2Eextreal] :
      ( ( inj__ty_2Enum_2Enum @ ( fo__c_2Eextreal_2Eceiling @ X0 ) )
      = ( ap @ c_2Eextreal_2Eceiling @ ( inj__ty_2Eextreal_2Eextreal @ X0 ) ) ) ).

thf(tp_c_2Eextreal_2Eext__mono__decreasing,type,
    c_2Eextreal_2Eext__mono__decreasing: $i ).

thf(mem_c_2Eextreal_2Eext__mono__decreasing,axiom,
    mem @ c_2Eextreal_2Eext__mono__decreasing @ ( arr @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) @ bool ) ).

thf(tp_c_2Eextreal_2Eext__mono__increasing,type,
    c_2Eextreal_2Eext__mono__increasing: $i ).

thf(mem_c_2Eextreal_2Eext__mono__increasing,axiom,
    mem @ c_2Eextreal_2Eext__mono__increasing @ ( arr @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) @ bool ) ).

thf(tp_c_2Eextreal_2Eext__suminf,type,
    c_2Eextreal_2Eext__suminf: $i ).

thf(mem_c_2Eextreal_2Eext__suminf,axiom,
    mem @ c_2Eextreal_2Eext__suminf @ ( arr @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) @ ty_2Eextreal_2Eextreal ) ).

thf(tp_c_2Eextreal_2Eextreal__CASE,type,
    c_2Eextreal_2Eextreal__CASE: del > $i ).

thf(mem_c_2Eextreal_2Eextreal__CASE,axiom,
    ! [A_27a: del] : ( mem @ ( c_2Eextreal_2Eextreal__CASE @ A_27a ) @ ( arr @ ty_2Eextreal_2Eextreal @ ( arr @ A_27a @ ( arr @ A_27a @ ( arr @ ( arr @ ty_2Erealax_2Ereal @ A_27a ) @ A_27a ) ) ) ) ) ).

thf(tp_c_2Eextreal_2Eextreal__abs,type,
    c_2Eextreal_2Eextreal__abs: $i ).

thf(mem_c_2Eextreal_2Eextreal__abs,axiom,
    mem @ c_2Eextreal_2Eextreal__abs @ ( arr @ ty_2Eextreal_2Eextreal @ ty_2Eextreal_2Eextreal ) ).

thf(stp_fo_c_2Eextreal_2Eextreal__abs,type,
    fo__c_2Eextreal_2Eextreal__abs: tp__ty_2Eextreal_2Eextreal > tp__ty_2Eextreal_2Eextreal ).

thf(stp_eq_fo_c_2Eextreal_2Eextreal__abs,axiom,
    ! [X0: tp__ty_2Eextreal_2Eextreal] :
      ( ( inj__ty_2Eextreal_2Eextreal @ ( fo__c_2Eextreal_2Eextreal__abs @ X0 ) )
      = ( ap @ c_2Eextreal_2Eextreal__abs @ ( inj__ty_2Eextreal_2Eextreal @ X0 ) ) ) ).

thf(tp_c_2Eextreal_2Eextreal__add,type,
    c_2Eextreal_2Eextreal__add: $i ).

thf(mem_c_2Eextreal_2Eextreal__add,axiom,
    mem @ c_2Eextreal_2Eextreal__add @ ( arr @ ty_2Eextreal_2Eextreal @ ( arr @ ty_2Eextreal_2Eextreal @ ty_2Eextreal_2Eextreal ) ) ).

thf(stp_fo_c_2Eextreal_2Eextreal__add,type,
    fo__c_2Eextreal_2Eextreal__add: tp__ty_2Eextreal_2Eextreal > tp__ty_2Eextreal_2Eextreal > tp__ty_2Eextreal_2Eextreal ).

thf(stp_eq_fo_c_2Eextreal_2Eextreal__add,axiom,
    ! [X0: tp__ty_2Eextreal_2Eextreal,X1: tp__ty_2Eextreal_2Eextreal] :
      ( ( inj__ty_2Eextreal_2Eextreal @ ( fo__c_2Eextreal_2Eextreal__add @ X0 @ X1 ) )
      = ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ X0 ) ) @ ( inj__ty_2Eextreal_2Eextreal @ X1 ) ) ) ).

thf(tp_c_2Eextreal_2Eextreal__ainv,type,
    c_2Eextreal_2Eextreal__ainv: $i ).

thf(mem_c_2Eextreal_2Eextreal__ainv,axiom,
    mem @ c_2Eextreal_2Eextreal__ainv @ ( arr @ ty_2Eextreal_2Eextreal @ ty_2Eextreal_2Eextreal ) ).

thf(stp_fo_c_2Eextreal_2Eextreal__ainv,type,
    fo__c_2Eextreal_2Eextreal__ainv: tp__ty_2Eextreal_2Eextreal > tp__ty_2Eextreal_2Eextreal ).

thf(stp_eq_fo_c_2Eextreal_2Eextreal__ainv,axiom,
    ! [X0: tp__ty_2Eextreal_2Eextreal] :
      ( ( inj__ty_2Eextreal_2Eextreal @ ( fo__c_2Eextreal_2Eextreal__ainv @ X0 ) )
      = ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ X0 ) ) ) ).

thf(tp_c_2Eextreal_2Eextreal__div,type,
    c_2Eextreal_2Eextreal__div: $i ).

thf(mem_c_2Eextreal_2Eextreal__div,axiom,
    mem @ c_2Eextreal_2Eextreal__div @ ( arr @ ty_2Eextreal_2Eextreal @ ( arr @ ty_2Eextreal_2Eextreal @ ty_2Eextreal_2Eextreal ) ) ).

thf(stp_fo_c_2Eextreal_2Eextreal__div,type,
    fo__c_2Eextreal_2Eextreal__div: tp__ty_2Eextreal_2Eextreal > tp__ty_2Eextreal_2Eextreal > tp__ty_2Eextreal_2Eextreal ).

thf(stp_eq_fo_c_2Eextreal_2Eextreal__div,axiom,
    ! [X0: tp__ty_2Eextreal_2Eextreal,X1: tp__ty_2Eextreal_2Eextreal] :
      ( ( inj__ty_2Eextreal_2Eextreal @ ( fo__c_2Eextreal_2Eextreal__div @ X0 @ X1 ) )
      = ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( inj__ty_2Eextreal_2Eextreal @ X0 ) ) @ ( inj__ty_2Eextreal_2Eextreal @ X1 ) ) ) ).

thf(tp_c_2Eextreal_2Eextreal__exp,type,
    c_2Eextreal_2Eextreal__exp: $i ).

thf(mem_c_2Eextreal_2Eextreal__exp,axiom,
    mem @ c_2Eextreal_2Eextreal__exp @ ( arr @ ty_2Eextreal_2Eextreal @ ty_2Eextreal_2Eextreal ) ).

thf(stp_fo_c_2Eextreal_2Eextreal__exp,type,
    fo__c_2Eextreal_2Eextreal__exp: tp__ty_2Eextreal_2Eextreal > tp__ty_2Eextreal_2Eextreal ).

thf(stp_eq_fo_c_2Eextreal_2Eextreal__exp,axiom,
    ! [X0: tp__ty_2Eextreal_2Eextreal] :
      ( ( inj__ty_2Eextreal_2Eextreal @ ( fo__c_2Eextreal_2Eextreal__exp @ X0 ) )
      = ( ap @ c_2Eextreal_2Eextreal__exp @ ( inj__ty_2Eextreal_2Eextreal @ X0 ) ) ) ).

thf(tp_c_2Eextreal_2Eextreal__inf,type,
    c_2Eextreal_2Eextreal__inf: $i ).

thf(mem_c_2Eextreal_2Eextreal__inf,axiom,
    mem @ c_2Eextreal_2Eextreal__inf @ ( arr @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) @ ty_2Eextreal_2Eextreal ) ).

thf(tp_c_2Eextreal_2Eextreal__inv,type,
    c_2Eextreal_2Eextreal__inv: $i ).

thf(mem_c_2Eextreal_2Eextreal__inv,axiom,
    mem @ c_2Eextreal_2Eextreal__inv @ ( arr @ ty_2Eextreal_2Eextreal @ ty_2Eextreal_2Eextreal ) ).

thf(stp_fo_c_2Eextreal_2Eextreal__inv,type,
    fo__c_2Eextreal_2Eextreal__inv: tp__ty_2Eextreal_2Eextreal > tp__ty_2Eextreal_2Eextreal ).

thf(stp_eq_fo_c_2Eextreal_2Eextreal__inv,axiom,
    ! [X0: tp__ty_2Eextreal_2Eextreal] :
      ( ( inj__ty_2Eextreal_2Eextreal @ ( fo__c_2Eextreal_2Eextreal__inv @ X0 ) )
      = ( ap @ c_2Eextreal_2Eextreal__inv @ ( inj__ty_2Eextreal_2Eextreal @ X0 ) ) ) ).

thf(tp_c_2Eextreal_2Eextreal__le,type,
    c_2Eextreal_2Eextreal__le: $i ).

thf(mem_c_2Eextreal_2Eextreal__le,axiom,
    mem @ c_2Eextreal_2Eextreal__le @ ( arr @ ty_2Eextreal_2Eextreal @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) ) ).

thf(tp_c_2Eextreal_2Eextreal__lg,type,
    c_2Eextreal_2Eextreal__lg: $i ).

thf(mem_c_2Eextreal_2Eextreal__lg,axiom,
    mem @ c_2Eextreal_2Eextreal__lg @ ( arr @ ty_2Eextreal_2Eextreal @ ty_2Eextreal_2Eextreal ) ).

thf(stp_fo_c_2Eextreal_2Eextreal__lg,type,
    fo__c_2Eextreal_2Eextreal__lg: tp__ty_2Eextreal_2Eextreal > tp__ty_2Eextreal_2Eextreal ).

thf(stp_eq_fo_c_2Eextreal_2Eextreal__lg,axiom,
    ! [X0: tp__ty_2Eextreal_2Eextreal] :
      ( ( inj__ty_2Eextreal_2Eextreal @ ( fo__c_2Eextreal_2Eextreal__lg @ X0 ) )
      = ( ap @ c_2Eextreal_2Eextreal__lg @ ( inj__ty_2Eextreal_2Eextreal @ X0 ) ) ) ).

thf(tp_c_2Eextreal_2Eextreal__logr,type,
    c_2Eextreal_2Eextreal__logr: $i ).

thf(mem_c_2Eextreal_2Eextreal__logr,axiom,
    mem @ c_2Eextreal_2Eextreal__logr @ ( arr @ ty_2Erealax_2Ereal @ ( arr @ ty_2Eextreal_2Eextreal @ ty_2Eextreal_2Eextreal ) ) ).

thf(stp_fo_c_2Eextreal_2Eextreal__logr,type,
    fo__c_2Eextreal_2Eextreal__logr: tp__ty_2Erealax_2Ereal > tp__ty_2Eextreal_2Eextreal > tp__ty_2Eextreal_2Eextreal ).

thf(stp_eq_fo_c_2Eextreal_2Eextreal__logr,axiom,
    ! [X0: tp__ty_2Erealax_2Ereal,X1: tp__ty_2Eextreal_2Eextreal] :
      ( ( inj__ty_2Eextreal_2Eextreal @ ( fo__c_2Eextreal_2Eextreal__logr @ X0 @ X1 ) )
      = ( ap @ ( ap @ c_2Eextreal_2Eextreal__logr @ ( inj__ty_2Erealax_2Ereal @ X0 ) ) @ ( inj__ty_2Eextreal_2Eextreal @ X1 ) ) ) ).

thf(tp_c_2Eextreal_2Eextreal__lt,type,
    c_2Eextreal_2Eextreal__lt: $i ).

thf(mem_c_2Eextreal_2Eextreal__lt,axiom,
    mem @ c_2Eextreal_2Eextreal__lt @ ( arr @ ty_2Eextreal_2Eextreal @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) ) ).

thf(tp_c_2Eextreal_2Eextreal__max,type,
    c_2Eextreal_2Eextreal__max: $i ).

thf(mem_c_2Eextreal_2Eextreal__max,axiom,
    mem @ c_2Eextreal_2Eextreal__max @ ( arr @ ty_2Eextreal_2Eextreal @ ( arr @ ty_2Eextreal_2Eextreal @ ty_2Eextreal_2Eextreal ) ) ).

thf(stp_fo_c_2Eextreal_2Eextreal__max,type,
    fo__c_2Eextreal_2Eextreal__max: tp__ty_2Eextreal_2Eextreal > tp__ty_2Eextreal_2Eextreal > tp__ty_2Eextreal_2Eextreal ).

thf(stp_eq_fo_c_2Eextreal_2Eextreal__max,axiom,
    ! [X0: tp__ty_2Eextreal_2Eextreal,X1: tp__ty_2Eextreal_2Eextreal] :
      ( ( inj__ty_2Eextreal_2Eextreal @ ( fo__c_2Eextreal_2Eextreal__max @ X0 @ X1 ) )
      = ( ap @ ( ap @ c_2Eextreal_2Eextreal__max @ ( inj__ty_2Eextreal_2Eextreal @ X0 ) ) @ ( inj__ty_2Eextreal_2Eextreal @ X1 ) ) ) ).

thf(tp_c_2Eextreal_2Eextreal__min,type,
    c_2Eextreal_2Eextreal__min: $i ).

thf(mem_c_2Eextreal_2Eextreal__min,axiom,
    mem @ c_2Eextreal_2Eextreal__min @ ( arr @ ty_2Eextreal_2Eextreal @ ( arr @ ty_2Eextreal_2Eextreal @ ty_2Eextreal_2Eextreal ) ) ).

thf(stp_fo_c_2Eextreal_2Eextreal__min,type,
    fo__c_2Eextreal_2Eextreal__min: tp__ty_2Eextreal_2Eextreal > tp__ty_2Eextreal_2Eextreal > tp__ty_2Eextreal_2Eextreal ).

thf(stp_eq_fo_c_2Eextreal_2Eextreal__min,axiom,
    ! [X0: tp__ty_2Eextreal_2Eextreal,X1: tp__ty_2Eextreal_2Eextreal] :
      ( ( inj__ty_2Eextreal_2Eextreal @ ( fo__c_2Eextreal_2Eextreal__min @ X0 @ X1 ) )
      = ( ap @ ( ap @ c_2Eextreal_2Eextreal__min @ ( inj__ty_2Eextreal_2Eextreal @ X0 ) ) @ ( inj__ty_2Eextreal_2Eextreal @ X1 ) ) ) ).

thf(tp_c_2Eextreal_2Eextreal__mul,type,
    c_2Eextreal_2Eextreal__mul: $i ).

thf(mem_c_2Eextreal_2Eextreal__mul,axiom,
    mem @ c_2Eextreal_2Eextreal__mul @ ( arr @ ty_2Eextreal_2Eextreal @ ( arr @ ty_2Eextreal_2Eextreal @ ty_2Eextreal_2Eextreal ) ) ).

thf(stp_fo_c_2Eextreal_2Eextreal__mul,type,
    fo__c_2Eextreal_2Eextreal__mul: tp__ty_2Eextreal_2Eextreal > tp__ty_2Eextreal_2Eextreal > tp__ty_2Eextreal_2Eextreal ).

thf(stp_eq_fo_c_2Eextreal_2Eextreal__mul,axiom,
    ! [X0: tp__ty_2Eextreal_2Eextreal,X1: tp__ty_2Eextreal_2Eextreal] :
      ( ( inj__ty_2Eextreal_2Eextreal @ ( fo__c_2Eextreal_2Eextreal__mul @ X0 @ X1 ) )
      = ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ X0 ) ) @ ( inj__ty_2Eextreal_2Eextreal @ X1 ) ) ) ).

thf(tp_c_2Eextreal_2Eextreal__of__num,type,
    c_2Eextreal_2Eextreal__of__num: $i ).

thf(mem_c_2Eextreal_2Eextreal__of__num,axiom,
    mem @ c_2Eextreal_2Eextreal__of__num @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) ).

thf(stp_fo_c_2Eextreal_2Eextreal__of__num,type,
    fo__c_2Eextreal_2Eextreal__of__num: tp__ty_2Enum_2Enum > tp__ty_2Eextreal_2Eextreal ).

thf(stp_eq_fo_c_2Eextreal_2Eextreal__of__num,axiom,
    ! [X0: tp__ty_2Enum_2Enum] :
      ( ( inj__ty_2Eextreal_2Eextreal @ ( fo__c_2Eextreal_2Eextreal__of__num @ X0 ) )
      = ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ X0 ) ) ) ).

thf(tp_c_2Eextreal_2Eextreal__pow,type,
    c_2Eextreal_2Eextreal__pow: $i ).

thf(mem_c_2Eextreal_2Eextreal__pow,axiom,
    mem @ c_2Eextreal_2Eextreal__pow @ ( arr @ ty_2Eextreal_2Eextreal @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) ) ).

thf(stp_fo_c_2Eextreal_2Eextreal__pow,type,
    fo__c_2Eextreal_2Eextreal__pow: tp__ty_2Eextreal_2Eextreal > tp__ty_2Enum_2Enum > tp__ty_2Eextreal_2Eextreal ).

thf(stp_eq_fo_c_2Eextreal_2Eextreal__pow,axiom,
    ! [X0: tp__ty_2Eextreal_2Eextreal,X1: tp__ty_2Enum_2Enum] :
      ( ( inj__ty_2Eextreal_2Eextreal @ ( fo__c_2Eextreal_2Eextreal__pow @ X0 @ X1 ) )
      = ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ X0 ) ) @ ( inj__ty_2Enum_2Enum @ X1 ) ) ) ).

thf(tp_c_2Eextreal_2Eextreal__size,type,
    c_2Eextreal_2Eextreal__size: $i ).

thf(mem_c_2Eextreal_2Eextreal__size,axiom,
    mem @ c_2Eextreal_2Eextreal__size @ ( arr @ ty_2Eextreal_2Eextreal @ ty_2Enum_2Enum ) ).

thf(stp_fo_c_2Eextreal_2Eextreal__size,type,
    fo__c_2Eextreal_2Eextreal__size: tp__ty_2Eextreal_2Eextreal > tp__ty_2Enum_2Enum ).

thf(stp_eq_fo_c_2Eextreal_2Eextreal__size,axiom,
    ! [X0: tp__ty_2Eextreal_2Eextreal] :
      ( ( inj__ty_2Enum_2Enum @ ( fo__c_2Eextreal_2Eextreal__size @ X0 ) )
      = ( ap @ c_2Eextreal_2Eextreal__size @ ( inj__ty_2Eextreal_2Eextreal @ X0 ) ) ) ).

thf(tp_c_2Eextreal_2Eextreal__sqrt,type,
    c_2Eextreal_2Eextreal__sqrt: $i ).

thf(mem_c_2Eextreal_2Eextreal__sqrt,axiom,
    mem @ c_2Eextreal_2Eextreal__sqrt @ ( arr @ ty_2Eextreal_2Eextreal @ ty_2Eextreal_2Eextreal ) ).

thf(stp_fo_c_2Eextreal_2Eextreal__sqrt,type,
    fo__c_2Eextreal_2Eextreal__sqrt: tp__ty_2Eextreal_2Eextreal > tp__ty_2Eextreal_2Eextreal ).

thf(stp_eq_fo_c_2Eextreal_2Eextreal__sqrt,axiom,
    ! [X0: tp__ty_2Eextreal_2Eextreal] :
      ( ( inj__ty_2Eextreal_2Eextreal @ ( fo__c_2Eextreal_2Eextreal__sqrt @ X0 ) )
      = ( ap @ c_2Eextreal_2Eextreal__sqrt @ ( inj__ty_2Eextreal_2Eextreal @ X0 ) ) ) ).

thf(tp_c_2Eextreal_2Eextreal__sub,type,
    c_2Eextreal_2Eextreal__sub: $i ).

thf(mem_c_2Eextreal_2Eextreal__sub,axiom,
    mem @ c_2Eextreal_2Eextreal__sub @ ( arr @ ty_2Eextreal_2Eextreal @ ( arr @ ty_2Eextreal_2Eextreal @ ty_2Eextreal_2Eextreal ) ) ).

thf(stp_fo_c_2Eextreal_2Eextreal__sub,type,
    fo__c_2Eextreal_2Eextreal__sub: tp__ty_2Eextreal_2Eextreal > tp__ty_2Eextreal_2Eextreal > tp__ty_2Eextreal_2Eextreal ).

thf(stp_eq_fo_c_2Eextreal_2Eextreal__sub,axiom,
    ! [X0: tp__ty_2Eextreal_2Eextreal,X1: tp__ty_2Eextreal_2Eextreal] :
      ( ( inj__ty_2Eextreal_2Eextreal @ ( fo__c_2Eextreal_2Eextreal__sub @ X0 @ X1 ) )
      = ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ X0 ) ) @ ( inj__ty_2Eextreal_2Eextreal @ X1 ) ) ) ).

thf(tp_c_2Eextreal_2Eextreal__sup,type,
    c_2Eextreal_2Eextreal__sup: $i ).

thf(mem_c_2Eextreal_2Eextreal__sup,axiom,
    mem @ c_2Eextreal_2Eextreal__sup @ ( arr @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) @ ty_2Eextreal_2Eextreal ) ).

thf(tp_c_2Eextreal_2Emono__decreasing,type,
    c_2Eextreal_2Emono__decreasing: $i ).

thf(mem_c_2Eextreal_2Emono__decreasing,axiom,
    mem @ c_2Eextreal_2Emono__decreasing @ ( arr @ ( arr @ ty_2Enum_2Enum @ ty_2Erealax_2Ereal ) @ bool ) ).

thf(tp_c_2Eextreal_2Emono__increasing,type,
    c_2Eextreal_2Emono__increasing: $i ).

thf(mem_c_2Eextreal_2Emono__increasing,axiom,
    mem @ c_2Eextreal_2Emono__increasing @ ( arr @ ( arr @ ty_2Enum_2Enum @ ty_2Erealax_2Ereal ) @ bool ) ).

thf(tp_c_2Eextreal_2Eopen__interval,type,
    c_2Eextreal_2Eopen__interval: $i ).

thf(mem_c_2Eextreal_2Eopen__interval,axiom,
    mem @ c_2Eextreal_2Eopen__interval @ ( arr @ ty_2Eextreal_2Eextreal @ ( arr @ ty_2Eextreal_2Eextreal @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) ) ) ).

thf(tp_c_2Eextreal_2Eopen__intervals__set,type,
    c_2Eextreal_2Eopen__intervals__set: $i ).

thf(mem_c_2Eextreal_2Eopen__intervals__set,axiom,
    mem @ c_2Eextreal_2Eopen__intervals__set @ ( arr @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) @ bool ) ).

thf(tp_c_2Eextreal_2Erational__intervals,type,
    c_2Eextreal_2Erational__intervals: $i ).

thf(mem_c_2Eextreal_2Erational__intervals,axiom,
    mem @ c_2Eextreal_2Erational__intervals @ ( arr @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) @ bool ) ).

thf(tp_c_2Eextreal_2Ereal,type,
    c_2Eextreal_2Ereal: $i ).

thf(mem_c_2Eextreal_2Ereal,axiom,
    mem @ c_2Eextreal_2Ereal @ ( arr @ ty_2Eextreal_2Eextreal @ ty_2Erealax_2Ereal ) ).

thf(stp_fo_c_2Eextreal_2Ereal,type,
    fo__c_2Eextreal_2Ereal: tp__ty_2Eextreal_2Eextreal > tp__ty_2Erealax_2Ereal ).

thf(stp_eq_fo_c_2Eextreal_2Ereal,axiom,
    ! [X0: tp__ty_2Eextreal_2Eextreal] :
      ( ( inj__ty_2Erealax_2Ereal @ ( fo__c_2Eextreal_2Ereal @ X0 ) )
      = ( ap @ c_2Eextreal_2Ereal @ ( inj__ty_2Eextreal_2Eextreal @ X0 ) ) ) ).

thf(ax_thm_2Eextreal_2Eextreal__TY__DEF,axiom,
    ? [V0rep: $i] :
      ( ( mem @ V0rep @ ( arr @ ty_2Eextreal_2Eextreal @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal ) ) )
      & ( p
        @ ( ap
          @ ( ap @ ( c_2Ebool_2ETYPE__DEFINITION @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal ) @ ty_2Eextreal_2Eextreal )
            @ ( lam @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal )
              @ ^ [V1a0: $i] :
                  ( ap @ ( c_2Ebool_2E_21 @ ( arr @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal ) @ bool ) )
                  @ ( lam @ ( arr @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal ) @ bool )
                    @ ^ [V2_27extreal_27: $i] :
                        ( ap
                        @ ( ap @ c_2Emin_2E_3D_3D_3E
                          @ ( ap @ ( c_2Ebool_2E_21 @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal ) )
                            @ ( lam @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal )
                              @ ^ [V3a0: $i] :
                                  ( ap
                                  @ ( ap @ c_2Emin_2E_3D_3D_3E
                                    @ ( ap
                                      @ ( ap @ c_2Ebool_2E_5C_2F
                                        @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal ) ) @ V3a0 )
                                          @ ( ap @ ( ap @ ( ap @ ( c_2Eind__type_2ECONSTR @ ty_2Erealax_2Ereal ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) @ ( c_2Ebool_2EARB @ ty_2Erealax_2Ereal ) )
                                            @ ( lam @ ty_2Enum_2Enum
                                              @ ^ [V4n: $i] : ( c_2Eind__type_2EBOTTOM @ ty_2Erealax_2Ereal ) ) ) ) )
                                      @ ( ap
                                        @ ( ap @ c_2Ebool_2E_5C_2F
                                          @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal ) ) @ V3a0 )
                                            @ ( ap @ ( ap @ ( ap @ ( c_2Eind__type_2ECONSTR @ ty_2Erealax_2Ereal ) @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( c_2Ebool_2EARB @ ty_2Erealax_2Ereal ) )
                                              @ ( lam @ ty_2Enum_2Enum
                                                @ ^ [V5n: $i] : ( c_2Eind__type_2EBOTTOM @ ty_2Erealax_2Ereal ) ) ) ) )
                                        @ ( ap @ ( c_2Ebool_2E_3F @ ty_2Erealax_2Ereal )
                                          @ ( lam @ ty_2Erealax_2Ereal
                                            @ ^ [V6a: $i] :
                                                ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal ) ) @ V3a0 )
                                                @ ( ap
                                                  @ ( lam @ ty_2Erealax_2Ereal
                                                    @ ^ [V7a: $i] :
                                                        ( ap @ ( ap @ ( ap @ ( c_2Eind__type_2ECONSTR @ ty_2Erealax_2Ereal ) @ ( ap @ c_2Enum_2ESUC @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ V7a )
                                                        @ ( lam @ ty_2Enum_2Enum
                                                          @ ^ [V8n: $i] : ( c_2Eind__type_2EBOTTOM @ ty_2Erealax_2Ereal ) ) ) )
                                                  @ V6a ) ) ) ) ) ) )
                                  @ ( ap @ V2_27extreal_27 @ V3a0 ) ) ) ) )
                        @ ( ap @ V2_27extreal_27 @ V1a0 ) ) ) ) ) )
          @ V0rep ) ) ) ).

thf(ax_thm_2Eextreal_2Eextreal__case__def,axiom,
    ! [A_27a: del] :
      ( ! [V0v: $i] :
          ( ( mem @ V0v @ A_27a )
         => ! [V1v1: $i] :
              ( ( mem @ V1v1 @ A_27a )
             => ! [V2f: $i] :
                  ( ( mem @ V2f @ ( arr @ ty_2Erealax_2Ereal @ A_27a ) )
                 => ( ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Eextreal_2Eextreal__CASE @ A_27a ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ V0v ) @ V1v1 ) @ V2f )
                    = V0v ) ) ) )
      & ! [V3v: $i] :
          ( ( mem @ V3v @ A_27a )
         => ! [V4v1: $i] :
              ( ( mem @ V4v1 @ A_27a )
             => ! [V5f: $i] :
                  ( ( mem @ V5f @ ( arr @ ty_2Erealax_2Ereal @ A_27a ) )
                 => ( ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Eextreal_2Eextreal__CASE @ A_27a ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ V3v ) @ V4v1 ) @ V5f )
                    = V4v1 ) ) ) )
      & ! [V6a: tp__ty_2Erealax_2Ereal,V7v: $i] :
          ( ( mem @ V7v @ A_27a )
         => ! [V8v1: $i] :
              ( ( mem @ V8v1 @ A_27a )
             => ! [V9f: $i] :
                  ( ( mem @ V9f @ ( arr @ ty_2Erealax_2Ereal @ A_27a ) )
                 => ( ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Eextreal_2Eextreal__CASE @ A_27a ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V6a ) ) ) @ V7v ) @ V8v1 ) @ V9f )
                    = ( ap @ V9f @ ( inj__ty_2Erealax_2Ereal @ V6a ) ) ) ) ) ) ) ).

thf(ax_thm_2Eextreal_2Eextreal__size__def,axiom,
    ( ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Eextreal_2Eextreal__size @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
      = fo__c_2Enum_2E0 )
    & ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Eextreal_2Eextreal__size @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
      = fo__c_2Enum_2E0 )
    & ! [V0a: tp__ty_2Erealax_2Ereal] :
        ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Eextreal_2Eextreal__size @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0a ) ) ) )
        = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Edatatype__extreal,axiom,
    ! [V0extreal: $i] :
      ( ( mem @ V0extreal @ ( arr @ ty_2Eextreal_2Eextreal @ ( arr @ ty_2Eextreal_2Eextreal @ ( arr @ ( arr @ ty_2Erealax_2Ereal @ ty_2Eextreal_2Eextreal ) @ bool ) ) ) )
     => ( p @ ( ap @ ( c_2Ebool_2EDATATYPE @ bool ) @ ( ap @ ( ap @ ( ap @ V0extreal @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ c_2Eextreal_2ENormal ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__distinct,axiom,
    ( ( fo__c_2Eextreal_2ENegInf != fo__c_2Eextreal_2EPosInf )
    & ! [V0a: tp__ty_2Erealax_2Ereal] :
        ( fo__c_2Eextreal_2ENegInf
       != ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0a ) ) ) )
    & ! [V1a: tp__ty_2Erealax_2Ereal] :
        ( fo__c_2Eextreal_2EPosInf
       != ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1a ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__nchotomy,axiom,
    ! [V0ee: tp__ty_2Eextreal_2Eextreal] :
      ( ( V0ee = fo__c_2Eextreal_2ENegInf )
      | ( V0ee = fo__c_2Eextreal_2EPosInf )
      | ? [V1r: tp__ty_2Erealax_2Ereal] :
          ( V0ee
          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1r ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__Axiom,axiom,
    ! [A_27a: del,V0f0: $i] :
      ( ( mem @ V0f0 @ A_27a )
     => ! [V1f1: $i] :
          ( ( mem @ V1f1 @ A_27a )
         => ! [V2f2: $i] :
              ( ( mem @ V2f2 @ ( arr @ ty_2Erealax_2Ereal @ A_27a ) )
             => ? [V3fn: $i] :
                  ( ( mem @ V3fn @ ( arr @ ty_2Eextreal_2Eextreal @ A_27a ) )
                  & ( ( ap @ V3fn @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) )
                    = V0f0 )
                  & ( ( ap @ V3fn @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) )
                    = V1f1 )
                  & ! [V4a: tp__ty_2Erealax_2Ereal] :
                      ( ( ap @ V3fn @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V4a ) ) )
                      = ( ap @ V2f2 @ ( inj__ty_2Erealax_2Ereal @ V4a ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__induction,axiom,
    ! [V0P: $i] :
      ( ( mem @ V0P @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ( ( ( p @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
          & ( p @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
          & ! [V1r: tp__ty_2Erealax_2Ereal] : ( p @ ( ap @ V0P @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1r ) ) ) ) )
       => ! [V2e: tp__ty_2Eextreal_2Eextreal] : ( p @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ V2e ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__case__cong,axiom,
    ! [A_27a: del,V0v_27: $i] :
      ( ( mem @ V0v_27 @ A_27a )
     => ! [V1v1_27: $i] :
          ( ( mem @ V1v1_27 @ A_27a )
         => ! [V2f_27: $i] :
              ( ( mem @ V2f_27 @ ( arr @ ty_2Erealax_2Ereal @ A_27a ) )
             => ! [V3M: tp__ty_2Eextreal_2Eextreal,V4M_27: tp__ty_2Eextreal_2Eextreal,V5v: $i] :
                  ( ( mem @ V5v @ A_27a )
                 => ! [V6v1: $i] :
                      ( ( mem @ V6v1 @ A_27a )
                     => ! [V7f: $i] :
                          ( ( mem @ V7f @ ( arr @ ty_2Erealax_2Ereal @ A_27a ) )
                         => ( ( ( V3M = V4M_27 )
                              & ( ( V4M_27 = fo__c_2Eextreal_2ENegInf )
                               => ( V5v = V0v_27 ) )
                              & ( ( V4M_27 = fo__c_2Eextreal_2EPosInf )
                               => ( V6v1 = V1v1_27 ) )
                              & ! [V8a: tp__ty_2Erealax_2Ereal] :
                                  ( ( V4M_27
                                    = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V8a ) ) ) )
                                 => ( ( ap @ V7f @ ( inj__ty_2Erealax_2Ereal @ V8a ) )
                                    = ( ap @ V2f_27 @ ( inj__ty_2Erealax_2Ereal @ V8a ) ) ) ) )
                           => ( ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Eextreal_2Eextreal__CASE @ A_27a ) @ ( inj__ty_2Eextreal_2Eextreal @ V3M ) ) @ V5v ) @ V6v1 ) @ V7f )
                              = ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Eextreal_2Eextreal__CASE @ A_27a ) @ ( inj__ty_2Eextreal_2Eextreal @ V4M_27 ) ) @ V0v_27 ) @ V1v1_27 ) @ V2f_27 ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__case__eq,axiom,
    ! [A_27a: del,V0x: tp__ty_2Eextreal_2Eextreal,V1v: $i] :
      ( ( mem @ V1v @ A_27a )
     => ! [V2v1: $i] :
          ( ( mem @ V2v1 @ A_27a )
         => ! [V3f: $i] :
              ( ( mem @ V3f @ ( arr @ ty_2Erealax_2Ereal @ A_27a ) )
             => ! [V4v_27: $i] :
                  ( ( mem @ V4v_27 @ A_27a )
                 => ( ( ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Eextreal_2Eextreal__CASE @ A_27a ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ V1v ) @ V2v1 ) @ V3f )
                      = V4v_27 )
                  <=> ( ( ( V0x = fo__c_2Eextreal_2ENegInf )
                        & ( V1v = V4v_27 ) )
                      | ( ( V0x = fo__c_2Eextreal_2EPosInf )
                        & ( V2v1 = V4v_27 ) )
                      | ? [V5r: tp__ty_2Erealax_2Ereal] :
                          ( ( V0x
                            = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V5r ) ) ) )
                          & ( ( ap @ V3f @ ( inj__ty_2Erealax_2Ereal @ V5r ) )
                            = V4v_27 ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Eextreal_2Eextreal__of__num__def,axiom,
    ! [V0n: tp__ty_2Enum_2Enum] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ V0n ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) ) ) ).

thf(ax_thm_2Eextreal_2Ereal__def,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Erealax_2Ereal @ ( ap @ c_2Eextreal_2Ereal @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
      = ( surj__ty_2Erealax_2Ereal
        @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Erealax_2Ereal ) @ ( ap @ ( ap @ c_2Ebool_2E_5C_2F @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Eextreal_2Eextreal ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Eextreal_2Eextreal ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) )
          @ ( ap @ ( c_2Emin_2E_40 @ ty_2Erealax_2Ereal )
            @ ( lam @ ty_2Erealax_2Ereal
              @ ^ [V1r: $i] : ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Eextreal_2Eextreal ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Eextreal_2ENormal @ V1r ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ereal__normal,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal] :
      ( ( surj__ty_2Erealax_2Ereal @ ( ap @ c_2Eextreal_2Ereal @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) )
      = V0x ) ).

thf(conj_thm_2Eextreal_2Enormal__real,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V0x != fo__c_2Eextreal_2EPosInf ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ c_2Eextreal_2Ereal @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) )
        = V0x ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__add__ind,axiom,
    ! [V0P: $i] :
      ( ( mem @ V0P @ ( arr @ ty_2Eextreal_2Eextreal @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) ) )
     => ( ( ! [V1x: tp__ty_2Erealax_2Ereal,V2y: tp__ty_2Erealax_2Ereal] : ( p @ ( ap @ ( ap @ V0P @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V2y ) ) ) )
          & ! [V3a: tp__ty_2Eextreal_2Eextreal] : ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3a ) ) )
          & ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
          & ! [V4v2: tp__ty_2Erealax_2Ereal] : ( p @ ( ap @ ( ap @ V0P @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V4v2 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
          & ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
          & ! [V5v5: tp__ty_2Erealax_2Ereal] : ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V5v5 ) ) ) )
          & ! [V6v3: tp__ty_2Erealax_2Ereal] : ( p @ ( ap @ ( ap @ V0P @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V6v3 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) ) )
       => ! [V7v: tp__ty_2Eextreal_2Eextreal,V8v1: tp__ty_2Eextreal_2Eextreal] : ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ V7v ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V8v1 ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__add__def,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Erealax_2Ereal,V2a: tp__ty_2Eextreal_2Eextreal,V3v2: tp__ty_2Erealax_2Ereal,V4v5: tp__ty_2Erealax_2Ereal,V5v3: tp__ty_2Erealax_2Ereal] :
      ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ ( ap @ c_2Erealax_2Ereal__add @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) ) )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2a ) ) )
        = fo__c_2Eextreal_2EPosInf )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
        = fo__c_2Eextreal_2EPosInf )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V3v2 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
        = fo__c_2Eextreal_2EPosInf )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
        = fo__c_2Eextreal_2ENegInf )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V4v5 ) ) ) )
        = fo__c_2Eextreal_2ENegInf )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V5v3 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
        = fo__c_2Eextreal_2ENegInf ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__sub__ind,axiom,
    ! [V0P: $i] :
      ( ( mem @ V0P @ ( arr @ ty_2Eextreal_2Eextreal @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) ) )
     => ( ( ! [V1x: tp__ty_2Erealax_2Ereal,V2y: tp__ty_2Erealax_2Ereal] : ( p @ ( ap @ ( ap @ V0P @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V2y ) ) ) )
          & ! [V3a: tp__ty_2Eextreal_2Eextreal] : ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3a ) ) )
          & ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
          & ! [V4v2: tp__ty_2Erealax_2Ereal] : ( p @ ( ap @ ( ap @ V0P @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V4v2 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
          & ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
          & ! [V5v5: tp__ty_2Erealax_2Ereal] : ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V5v5 ) ) ) )
          & ! [V6v3: tp__ty_2Erealax_2Ereal] : ( p @ ( ap @ ( ap @ V0P @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V6v3 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) ) )
       => ! [V7v: tp__ty_2Eextreal_2Eextreal,V8v1: tp__ty_2Eextreal_2Eextreal] : ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ V7v ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V8v1 ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__sub__def,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Erealax_2Ereal,V2a: tp__ty_2Eextreal_2Eextreal,V3v2: tp__ty_2Erealax_2Ereal,V4v5: tp__ty_2Erealax_2Ereal,V5v3: tp__ty_2Erealax_2Ereal] :
      ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ ( ap @ c_2Ereal_2Ereal__sub @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) ) )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2a ) ) )
        = fo__c_2Eextreal_2EPosInf )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
        = fo__c_2Eextreal_2ENegInf )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V3v2 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
        = fo__c_2Eextreal_2ENegInf )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
        = fo__c_2Eextreal_2EPosInf )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V4v5 ) ) ) )
        = fo__c_2Eextreal_2ENegInf )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V5v3 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
        = fo__c_2Eextreal_2EPosInf ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__le__ind,axiom,
    ! [V0P: $i] :
      ( ( mem @ V0P @ ( arr @ ty_2Eextreal_2Eextreal @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) ) )
     => ( ( ! [V1x: tp__ty_2Erealax_2Ereal,V2y: tp__ty_2Erealax_2Ereal] : ( p @ ( ap @ ( ap @ V0P @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V2y ) ) ) )
          & ! [V3a: tp__ty_2Eextreal_2Eextreal] : ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3a ) ) )
          & ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
          & ! [V4v2: tp__ty_2Erealax_2Ereal] : ( p @ ( ap @ ( ap @ V0P @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V4v2 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
          & ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
          & ! [V5v3: tp__ty_2Erealax_2Ereal] : ( p @ ( ap @ ( ap @ V0P @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V5v3 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
          & ! [V6v5: tp__ty_2Erealax_2Ereal] : ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V6v5 ) ) ) ) )
       => ! [V7v: tp__ty_2Eextreal_2Eextreal,V8v1: tp__ty_2Eextreal_2Eextreal] : ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ V7v ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V8v1 ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__le__def,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Erealax_2Ereal,V2a: tp__ty_2Eextreal_2Eextreal,V3v2: tp__ty_2Erealax_2Ereal,V4v3: tp__ty_2Erealax_2Ereal,V5v5: tp__ty_2Erealax_2Ereal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) )
      & ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2a ) ) )
      <=> $true )
      & ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
      <=> $true )
      & ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V3v2 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
      <=> $true )
      & ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
      <=> $false )
      & ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V4v3 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
      <=> $false )
      & ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V5v5 ) ) ) )
      <=> $false ) ) ).

thf(ax_thm_2Eextreal_2Eextreal__lt__def,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
    <=> ~ ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__mul__ind,axiom,
    ! [V0P: $i] :
      ( ( mem @ V0P @ ( arr @ ty_2Eextreal_2Eextreal @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) ) )
     => ( ( ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
          & ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
          & ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
          & ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
          & ! [V1x: tp__ty_2Erealax_2Ereal] : ( p @ ( ap @ ( ap @ V0P @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
          & ! [V2y: tp__ty_2Erealax_2Ereal] : ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V2y ) ) ) )
          & ! [V3x: tp__ty_2Erealax_2Ereal] : ( p @ ( ap @ ( ap @ V0P @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V3x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
          & ! [V4y: tp__ty_2Erealax_2Ereal] : ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V4y ) ) ) )
          & ! [V5x: tp__ty_2Erealax_2Ereal,V6y: tp__ty_2Erealax_2Ereal] : ( p @ ( ap @ ( ap @ V0P @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V5x ) ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V6y ) ) ) ) )
       => ! [V7v: tp__ty_2Eextreal_2Eextreal,V8v1: tp__ty_2Eextreal_2Eextreal] : ( p @ ( ap @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ V7v ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V8v1 ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__mul__def,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Erealax_2Ereal] :
      ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
        = fo__c_2Eextreal_2EPosInf )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
        = fo__c_2Eextreal_2ENegInf )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
        = fo__c_2Eextreal_2ENegInf )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
        = fo__c_2Eextreal_2EPosInf )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Eextreal_2Eextreal ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Erealax_2Ereal ) @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Eextreal_2Eextreal ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) ) ) )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Eextreal_2Eextreal ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Erealax_2Ereal ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Eextreal_2Eextreal ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) ) ) )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Eextreal_2Eextreal ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Erealax_2Ereal ) @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Eextreal_2Eextreal ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) ) ) )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Eextreal_2Eextreal ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Erealax_2Ereal ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Eextreal_2Eextreal ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) ) ) )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ ( ap @ c_2Erealax_2Ereal__mul @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) ) ) ) ).

thf(ax_thm_2Eextreal_2Eextreal__inv__def,axiom,
    ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__inv @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
    & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__inv @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
    & ! [V0x: tp__ty_2Erealax_2Ereal] :
        ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__inv @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ c_2Erealax_2Einv @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) ) ) ) ).

thf(ax_thm_2Eextreal_2Eextreal__ainv__def,axiom,
    ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
      = fo__c_2Eextreal_2EPosInf )
    & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
      = fo__c_2Eextreal_2ENegInf )
    & ! [V0x: tp__ty_2Erealax_2Ereal] :
        ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ c_2Erealax_2Ereal__neg @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) ) ) ) ).

thf(ax_thm_2Eextreal_2Eextreal__div__def,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Eextreal_2Eextreal__inv @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(ax_thm_2Eextreal_2Eextreal__abs__primitive__def,axiom,
    ( c_2Eextreal_2Eextreal__abs
    = ( ap
      @ ( ap @ ( c_2Erelation_2EWFREC @ ty_2Eextreal_2Eextreal @ ty_2Eextreal_2Eextreal )
        @ ( ap @ ( c_2Emin_2E_40 @ ( arr @ ty_2Eextreal_2Eextreal @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) ) )
          @ ( lam @ ( arr @ ty_2Eextreal_2Eextreal @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
            @ ^ [V0R: $i] : ( ap @ ( c_2Erelation_2EWF @ ty_2Eextreal_2Eextreal ) @ V0R ) ) ) )
      @ ( lam @ ( arr @ ty_2Eextreal_2Eextreal @ ty_2Eextreal_2Eextreal )
        @ ^ [V1extreal__abs: $i] :
            ( lam @ ty_2Eextreal_2Eextreal
            @ ^ [V2a: $i] :
                ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Eextreal_2Eextreal__CASE @ ty_2Eextreal_2Eextreal ) @ V2a ) @ ( ap @ ( c_2Ecombin_2EI @ ty_2Eextreal_2Eextreal ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) ) @ ( ap @ ( c_2Ecombin_2EI @ ty_2Eextreal_2Eextreal ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
                @ ( lam @ ty_2Erealax_2Ereal
                  @ ^ [V3x: $i] : ( ap @ ( c_2Ecombin_2EI @ ty_2Eextreal_2Eextreal ) @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ c_2Ereal_2Eabs @ V3x ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__abs__ind,axiom,
    ! [V0P: $i] :
      ( ( mem @ V0P @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ( ( ! [V1x: tp__ty_2Erealax_2Ereal] : ( p @ ( ap @ V0P @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) )
          & ( p @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
          & ( p @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) ) )
       => ! [V2v: tp__ty_2Eextreal_2Eextreal] : ( p @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ V2v ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__abs__def,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal] :
      ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__abs @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ c_2Ereal_2Eabs @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) ) )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__abs @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
        = fo__c_2Eextreal_2EPosInf )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__abs @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
        = fo__c_2Eextreal_2EPosInf ) ) ).

thf(ax_thm_2Eextreal_2Eextreal__logr__def,axiom,
    ( ! [V0b: tp__ty_2Erealax_2Ereal,V1x: tp__ty_2Erealax_2Ereal] :
        ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__logr @ ( inj__ty_2Erealax_2Ereal @ V0b ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ ( ap @ c_2Eutil__prob_2Elogr @ ( inj__ty_2Erealax_2Ereal @ V0b ) ) @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) ) )
    & ! [V2b: tp__ty_2Erealax_2Ereal] :
        ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__logr @ ( inj__ty_2Erealax_2Ereal @ V2b ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
        = fo__c_2Eextreal_2EPosInf )
    & ! [V3b: tp__ty_2Erealax_2Ereal] :
        ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__logr @ ( inj__ty_2Erealax_2Ereal @ V3b ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
        = fo__c_2Eextreal_2ENegInf ) ) ).

thf(ax_thm_2Eextreal_2Eextreal__lg__def,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__lg @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__logr @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ).

thf(ax_thm_2Eextreal_2Eextreal__exp__def,axiom,
    ( ! [V0x: tp__ty_2Erealax_2Ereal] :
        ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__exp @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ c_2Etransc_2Eexp @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) ) )
    & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__exp @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
      = fo__c_2Eextreal_2EPosInf )
    & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__exp @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ) ).

thf(ax_thm_2Eextreal_2Eextreal__pow__def,axiom,
    ( ! [V0a: tp__ty_2Erealax_2Ereal,V1n: tp__ty_2Enum_2Enum] :
        ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0a ) ) ) @ ( inj__ty_2Enum_2Enum @ V1n ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( inj__ty_2Erealax_2Ereal @ V0a ) ) @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) ) )
    & ! [V2n: tp__ty_2Enum_2Enum] :
        ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( inj__ty_2Enum_2Enum @ V2n ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Eextreal_2Eextreal ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Enum_2Enum ) @ ( inj__ty_2Enum_2Enum @ V2n ) ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) ) )
    & ! [V3n: tp__ty_2Enum_2Enum] :
        ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Enum_2Enum @ V3n ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Eextreal_2Eextreal ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Enum_2Enum ) @ ( inj__ty_2Enum_2Enum @ V3n ) ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Eextreal_2Eextreal ) @ ( ap @ c_2Earithmetic_2EEVEN @ ( inj__ty_2Enum_2Enum @ V3n ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) ) ) ) ) ).

thf(ax_thm_2Eextreal_2Eextreal__sqrt__def,axiom,
    ( ! [V0x: tp__ty_2Erealax_2Ereal] :
        ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__sqrt @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ c_2Etransc_2Esqrt @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) ) )
    & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__sqrt @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
      = fo__c_2Eextreal_2EPosInf ) ) ).

thf(conj_thm_2Eextreal_2EREAL__LT__LMUL__0__NEG,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Erealax_2Ereal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__mul @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) )
        & ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EREAL__LT__RMUL__0__NEG,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Erealax_2Ereal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__mul @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) )
        & ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EREAL__LT__LMUL__NEG__0,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Erealax_2Ereal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ ( ap @ c_2Erealax_2Ereal__mul @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
        & ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EREAL__LT__RMUL__NEG__0,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Erealax_2Ereal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ ( ap @ c_2Erealax_2Ereal__mul @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
        & ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EREAL__LT__LMUL__NEG__0__NEG,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Erealax_2Ereal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ ( ap @ c_2Erealax_2Ereal__mul @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
        & ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) ) ).

thf(conj_thm_2Eextreal_2EREAL__LT__RMUL__NEG__0__NEG,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Erealax_2Ereal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ ( ap @ c_2Erealax_2Ereal__mul @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
        & ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) ) ).

thf(conj_thm_2Eextreal_2EREAL__LT__RDIV__EQ__NEG,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Erealax_2Ereal,V2z: tp__ty_2Erealax_2Ereal] :
      ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
     => ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ ( ap @ c_2Ereal_2E_2F @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ ( ap @ c_2Erealax_2Ereal__mul @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EREAL__LE__RDIV__EQ__NEG,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Erealax_2Ereal,V2z: tp__ty_2Erealax_2Ereal] :
      ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
     => ( ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ ( ap @ c_2Ereal_2E_2F @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ ( ap @ c_2Erealax_2Ereal__mul @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EPOW__POS__EVEN,axiom,
    ! [V0n: tp__ty_2Enum_2Enum,V1x: tp__ty_2Erealax_2Ereal] :
      ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
     => ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) )
      <=> ( p @ ( ap @ c_2Earithmetic_2EEVEN @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EPOW__NEG__ODD,axiom,
    ! [V0n: tp__ty_2Enum_2Enum,V1x: tp__ty_2Erealax_2Ereal] :
      ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
     => ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
      <=> ( p @ ( ap @ c_2Earithmetic_2EODD @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2ELOGR__MONO__LE,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Erealax_2Ereal,V2b: tp__ty_2Erealax_2Ereal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) )
        & ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V2b ) ) ) )
     => ( ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ ( ap @ c_2Eutil__prob_2Elogr @ ( inj__ty_2Erealax_2Ereal @ V2b ) ) @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) @ ( ap @ ( ap @ c_2Eutil__prob_2Elogr @ ( inj__ty_2Erealax_2Ereal @ V2b ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2ELOGR__MONO__LE__IMP,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Erealax_2Ereal,V2b: tp__ty_2Erealax_2Ereal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) )
        & ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V2b ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ ( ap @ c_2Eutil__prob_2Elogr @ ( inj__ty_2Erealax_2Ereal @ V2b ) ) @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) @ ( ap @ ( ap @ c_2Eutil__prob_2Elogr @ ( inj__ty_2Erealax_2Ereal @ V2b ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) ) ) ).

thf(ax_thm_2Eextreal_2Emono__increasing__def,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Erealax_2Ereal ) )
     => ( ( p @ ( ap @ c_2Eextreal_2Emono__increasing @ V0f ) )
      <=> ! [V1m: tp__ty_2Enum_2Enum,V2n: tp__ty_2Enum_2Enum] :
            ( ( p @ ( ap @ ( ap @ c_2Earithmetic_2E_3C_3D @ ( inj__ty_2Enum_2Enum @ V1m ) ) @ ( inj__ty_2Enum_2Enum @ V2n ) ) )
           => ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V1m ) ) ) @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Emono__increasing__suc,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Erealax_2Ereal ) )
     => ( ( p @ ( ap @ c_2Eextreal_2Emono__increasing @ V0f ) )
      <=> ! [V1n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) @ ( ap @ V0f @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) ) ) ) ) ).

thf(ax_thm_2Eextreal_2Emono__decreasing__def,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Erealax_2Ereal ) )
     => ( ( p @ ( ap @ c_2Eextreal_2Emono__decreasing @ V0f ) )
      <=> ! [V1m: tp__ty_2Enum_2Enum,V2n: tp__ty_2Enum_2Enum] :
            ( ( p @ ( ap @ ( ap @ c_2Earithmetic_2E_3C_3D @ ( inj__ty_2Enum_2Enum @ V1m ) ) @ ( inj__ty_2Enum_2Enum @ V2n ) ) )
           => ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V1m ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Emono__decreasing__suc,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Erealax_2Ereal ) )
     => ( ( p @ ( ap @ c_2Eextreal_2Emono__decreasing @ V0f ) )
      <=> ! [V1n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ V0f @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) ) @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Emono__increasing__converges__to__sup,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Erealax_2Ereal ) )
     => ! [V1r: tp__ty_2Erealax_2Ereal] :
          ( ( ( p @ ( ap @ c_2Eextreal_2Emono__increasing @ V0f ) )
            & ( p @ ( ap @ ( ap @ c_2Eseq_2E_2D_2D_3E @ V0f ) @ ( inj__ty_2Erealax_2Ereal @ V1r ) ) ) )
         => ( V1r
            = ( surj__ty_2Erealax_2Ereal @ ( ap @ c_2Ereal_2Esup @ ( ap @ ( ap @ ( c_2Epred__set_2EIMAGE @ ty_2Enum_2Enum @ ty_2Erealax_2Ereal ) @ V0f ) @ ( c_2Epred__set_2EUNIV @ ty_2Enum_2Enum ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__cases,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( V0x = fo__c_2Eextreal_2ENegInf )
      | ( V0x = fo__c_2Eextreal_2EPosInf )
      | ? [V1r: tp__ty_2Erealax_2Ereal] :
          ( V0x
          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1r ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__eq__zero,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal] :
      ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
    <=> ( V0x
        = ( surj__ty_2Erealax_2Ereal @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__not__infty,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal] :
      ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) )
       != fo__c_2Eextreal_2ENegInf )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) )
       != fo__c_2Eextreal_2EPosInf ) ) ).

thf(conj_thm_2Eextreal_2Enum__not__infty,axiom,
    ! [V0n: tp__ty_2Enum_2Enum] :
      ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ V0n ) ) )
       != fo__c_2Eextreal_2ENegInf )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ V0n ) ) )
       != fo__c_2Eextreal_2EPosInf ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__11,axiom,
    ! [V0a: tp__ty_2Erealax_2Ereal,V1a_27: tp__ty_2Erealax_2Ereal] :
      ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0a ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1a_27 ) ) ) )
    <=> ( V0a = V1a_27 ) ) ).

thf(conj_thm_2Eextreal_2Emul__rzero,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ).

thf(conj_thm_2Eextreal_2Emul__lzero,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ).

thf(conj_thm_2Eextreal_2Emul__rone,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
      = V0x ) ).

thf(conj_thm_2Eextreal_2Emul__lone,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
      = V0x ) ).

thf(conj_thm_2Eextreal_2Eentire,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
    <=> ( ( V0x
          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
        | ( V1y
          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__lt__eq,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Erealax_2Ereal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) )
    <=> ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__refl,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__refl,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ~ ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__infty,axiom,
    ( ! [V0x: tp__ty_2Eextreal_2Eextreal] :
        ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) ) )
    & ! [V1x: tp__ty_2Eextreal_2Eextreal] :
        ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
      <=> ( V1x = fo__c_2Eextreal_2ENegInf ) )
    & ! [V2x: tp__ty_2Eextreal_2Eextreal] :
        ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2x ) ) )
      <=> ( V2x = fo__c_2Eextreal_2EPosInf ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__infty,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Erealax_2Ereal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) )
      & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
      & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
      & ~ ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
      & ~ ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
      & ( ( V0x != fo__c_2Eextreal_2EPosInf )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) ) )
      & ( ( V0x != fo__c_2Eextreal_2ENegInf )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__imp__le,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__imp__ne,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
     => ( V0x != V1y ) ) ).

thf(conj_thm_2Eextreal_2Ele__trans,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__trans,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elet__trans,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__antisym,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) )
    <=> ( V0x = V1y ) ) ).

thf(conj_thm_2Eextreal_2Elt__antisym,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ~ ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elte__trans,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__total,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
      | ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__total,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( V0x = V1y )
      | ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
      | ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__01,axiom,
    p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__01,axiom,
    p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ene__01,axiom,
    ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) )
   != ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__02,axiom,
    p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__02,axiom,
    p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ene__02,axiom,
    ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) )
   != ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__num,axiom,
    ! [V0n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__le,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
    <=> ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
        & ( V0x != V1y ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__lt,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
    <=> ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
        | ( V0x = V1y ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__neg,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
    <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__neg,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
    <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__add,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__add,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elet__add,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elte__add,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__add2,axiom,
    ! [V0w: tp__ty_2Eextreal_2Eextreal,V1x: tp__ty_2Eextreal_2Eextreal,V2y: tp__ty_2Eextreal_2Eextreal,V3z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0w ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3z ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0w ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3z ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__add2,axiom,
    ! [V0w: tp__ty_2Eextreal_2Eextreal,V1x: tp__ty_2Eextreal_2Eextreal,V2y: tp__ty_2Eextreal_2Eextreal,V3z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0w ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3z ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0w ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3z ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elet__add2,axiom,
    ! [V0w: tp__ty_2Eextreal_2Eextreal,V1x: tp__ty_2Eextreal_2Eextreal,V2y: tp__ty_2Eextreal_2Eextreal,V3z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0w != fo__c_2Eextreal_2ENegInf )
        & ( V0w != fo__c_2Eextreal_2EPosInf )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0w ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3z ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0w ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3z ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elet__add2__alt,axiom,
    ! [V0w: tp__ty_2Eextreal_2Eextreal,V1x: tp__ty_2Eextreal_2Eextreal,V2y: tp__ty_2Eextreal_2Eextreal,V3z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V1x != fo__c_2Eextreal_2ENegInf )
        & ( V1x != fo__c_2Eextreal_2EPosInf )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0w ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3z ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0w ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3z ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__addr,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V0x != fo__c_2Eextreal_2EPosInf ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__addr__imp,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__ladd,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V0x != fo__c_2Eextreal_2EPosInf ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__radd,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V0x != fo__c_2Eextreal_2EPosInf ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__radd__imp,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__ladd__imp,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__ladd,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V0x != fo__c_2Eextreal_2EPosInf ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__radd,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V0x != fo__c_2Eextreal_2EPosInf ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__addl,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V1y != fo__c_2Eextreal_2ENegInf )
        & ( V1y != fo__c_2Eextreal_2EPosInf ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__lneg,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
    <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__mul,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elet__mul,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elte__mul,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__mul__neg,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Emul__le,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__mul,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__mul__neg,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Emul__lt,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Emul__let,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Emul__lte,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__rmul__imp,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__lmul__imp,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__rmul,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) )
        & ( V2z != fo__c_2Eextreal_2EPosInf ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__lmul,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        & ( V0x != fo__c_2Eextreal_2EPosInf ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__mul2,axiom,
    ! [V0x1: tp__ty_2Eextreal_2Eextreal,V1x2: tp__ty_2Eextreal_2Eextreal,V2y1: tp__ty_2Eextreal_2Eextreal,V3y2: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x1 ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y1 ) ) )
        & ( V0x1 != fo__c_2Eextreal_2EPosInf )
        & ( V2y1 != fo__c_2Eextreal_2EPosInf )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x1 ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1x2 ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V2y1 ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3y2 ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x1 ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y1 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V1x2 ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3y2 ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eabs__pos,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__abs @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eabs__refl,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__abs @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        = V0x )
    <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eabs__bounds,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1k: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__abs @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1k ) ) )
    <=> ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ V1k ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1k ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eabs__bounds__lt,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1k: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__abs @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1k ) ) )
    <=> ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ V1k ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1k ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eadd__comm,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eadd__assoc,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eadd__not__infty,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
          & ( V1y != fo__c_2Eextreal_2ENegInf ) )
       => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
         != fo__c_2Eextreal_2ENegInf ) )
      & ( ( ( V0x != fo__c_2Eextreal_2EPosInf )
          & ( V1y != fo__c_2Eextreal_2EPosInf ) )
       => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
         != fo__c_2Eextreal_2EPosInf ) ) ) ).

thf(conj_thm_2Eextreal_2Eadd__rzero,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
      = V0x ) ).

thf(conj_thm_2Eextreal_2Eadd__lzero,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
      = V0x ) ).

thf(conj_thm_2Eextreal_2Eadd__infty,axiom,
    ( ! [V0x: tp__ty_2Eextreal_2Eextreal] :
        ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
          = fo__c_2Eextreal_2EPosInf )
        & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
          = fo__c_2Eextreal_2EPosInf ) )
    & ! [V1x: tp__ty_2Eextreal_2Eextreal] :
        ( ( V1x != fo__c_2Eextreal_2EPosInf )
       => ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
            = fo__c_2Eextreal_2ENegInf )
          & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) )
            = fo__c_2Eextreal_2ENegInf ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__EQ__LADD,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V0x != fo__c_2Eextreal_2EPosInf ) )
     => ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
      <=> ( V1y = V2z ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__rzero,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
      = V0x ) ).

thf(conj_thm_2Eextreal_2Esub__lzero,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__le__imp,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V0x != fo__c_2Eextreal_2EPosInf )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__le__imp2,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V1y != fo__c_2Eextreal_2ENegInf )
        & ( V1y != fo__c_2Eextreal_2EPosInf )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__sub__imp,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__sub__imp,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__lt__imp,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V0x != fo__c_2Eextreal_2EPosInf )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__lt__imp2,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V2z != fo__c_2Eextreal_2ENegInf )
        & ( V2z != fo__c_2Eextreal_2EPosInf )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__zero__lt,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__zero__lt2,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V0x != fo__c_2Eextreal_2EPosInf )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__lt__zero,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__lt__zero2,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V1y != fo__c_2Eextreal_2ENegInf )
        & ( V1y != fo__c_2Eextreal_2EPosInf )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__zero__le,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
    <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__le__zero,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V1y != fo__c_2Eextreal_2ENegInf )
        & ( V1y != fo__c_2Eextreal_2EPosInf ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__sub__eq,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V0x != fo__c_2Eextreal_2EPosInf ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__sub__eq2,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V2z != fo__c_2Eextreal_2ENegInf )
        & ( V2z != fo__c_2Eextreal_2EPosInf )
        & ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V1y != fo__c_2Eextreal_2ENegInf ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__le__eq,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V0x != fo__c_2Eextreal_2EPosInf ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__le__eq2,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V1y != fo__c_2Eextreal_2ENegInf )
        & ( V1y != fo__c_2Eextreal_2EPosInf )
        & ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V2z != fo__c_2Eextreal_2ENegInf ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__le__switch,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V0x != fo__c_2Eextreal_2EPosInf )
        & ( V2z != fo__c_2Eextreal_2ENegInf )
        & ( V2z != fo__c_2Eextreal_2EPosInf ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__le__switch2,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V0x != fo__c_2Eextreal_2EPosInf )
        & ( V1y != fo__c_2Eextreal_2ENegInf )
        & ( V1y != fo__c_2Eextreal_2EPosInf ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__sub,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V2z != fo__c_2Eextreal_2ENegInf )
        & ( V2z != fo__c_2Eextreal_2EPosInf ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__add2,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V0x != fo__c_2Eextreal_2EPosInf ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) )
        = V1y ) ) ).

thf(conj_thm_2Eextreal_2Eadd__sub,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V1y != fo__c_2Eextreal_2ENegInf )
        & ( V1y != fo__c_2Eextreal_2EPosInf ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
        = V0x ) ) ).

thf(conj_thm_2Eextreal_2Eadd__sub2,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V1y != fo__c_2Eextreal_2ENegInf )
        & ( V1y != fo__c_2Eextreal_2EPosInf ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
        = V0x ) ) ).

thf(conj_thm_2Eextreal_2Esub__add,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V1y != fo__c_2Eextreal_2ENegInf )
        & ( V1y != fo__c_2Eextreal_2EPosInf ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
        = V0x ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__sub__add,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__0,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
     => ( V0x = V1y ) ) ).

thf(conj_thm_2Eextreal_2Eneg__neg,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) )
      = V0x ) ).

thf(conj_thm_2Eextreal_2Eneg__0,axiom,
    ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
    = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eneg__eq0,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
    <=> ( V0x
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eeq__neg,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
    <=> ( V0x = V1y ) ) ).

thf(conj_thm_2Eextreal_2Eneg__minus1,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__rneg,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__lneg,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
          & ( V1y != fo__c_2Eextreal_2ENegInf ) )
        | ( ( V0x != fo__c_2Eextreal_2EPosInf )
          & ( V1y != fo__c_2Eextreal_2EPosInf ) ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eneg__sub,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
          & ( V0x != fo__c_2Eextreal_2EPosInf ) )
        | ( ( V1y != fo__c_2Eextreal_2ENegInf )
          & ( V1y != fo__c_2Eextreal_2EPosInf ) ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__not__infty,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
          & ( V1y != fo__c_2Eextreal_2EPosInf ) )
       => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
         != fo__c_2Eextreal_2ENegInf ) )
      & ( ( ( V0x != fo__c_2Eextreal_2EPosInf )
          & ( V1y != fo__c_2Eextreal_2ENegInf ) )
       => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
         != fo__c_2Eextreal_2EPosInf ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__lsub__imp,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eeq__sub__ladd__normal,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Erealax_2Ereal] :
      ( ( V0x
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) ) ) )
    <=> ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) ) )
        = V1y ) ) ).

thf(conj_thm_2Eextreal_2Eeq__sub__radd,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V1y != fo__c_2Eextreal_2ENegInf )
        & ( V1y != fo__c_2Eextreal_2EPosInf ) )
     => ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
          = V2z )
      <=> ( V0x
          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eeq__sub__ladd,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V2z != fo__c_2Eextreal_2ENegInf )
        & ( V2z != fo__c_2Eextreal_2EPosInf ) )
     => ( ( V0x
          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
      <=> ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) )
          = V1y ) ) ) ).

thf(conj_thm_2Eextreal_2Eeq__sub__switch,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Erealax_2Ereal] :
      ( ( V0x
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
    <=> ( V1y
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eeq__add__sub__switch,axiom,
    ! [V0a: tp__ty_2Eextreal_2Eextreal,V1b: tp__ty_2Eextreal_2Eextreal,V2c: tp__ty_2Eextreal_2Eextreal,V3d: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V1b != fo__c_2Eextreal_2ENegInf )
        & ( V1b != fo__c_2Eextreal_2EPosInf )
        & ( V2c != fo__c_2Eextreal_2ENegInf )
        & ( V2c != fo__c_2Eextreal_2EPosInf ) )
     => ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0a ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1b ) ) )
          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V2c ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3d ) ) ) )
      <=> ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V0a ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2c ) ) )
          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V3d ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1b ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__refl,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V0x != fo__c_2Eextreal_2EPosInf ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Emul__comm,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ).

thf(conj_thm_2Eextreal_2Emul__assoc,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ).

thf(conj_thm_2Eextreal_2Emul__not__infty,axiom,
    ( ! [V0c: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Eextreal_2Eextreal] :
        ( ( ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V0c ) ) )
          & ( V1y != fo__c_2Eextreal_2ENegInf ) )
       => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0c ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
         != fo__c_2Eextreal_2ENegInf ) )
    & ! [V2c: tp__ty_2Erealax_2Ereal,V3y: tp__ty_2Eextreal_2Eextreal] :
        ( ( ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V2c ) ) )
          & ( V3y != fo__c_2Eextreal_2EPosInf ) )
       => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V2c ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3y ) ) )
         != fo__c_2Eextreal_2EPosInf ) )
    & ! [V4c: tp__ty_2Erealax_2Ereal,V5y: tp__ty_2Eextreal_2Eextreal] :
        ( ( ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( inj__ty_2Erealax_2Ereal @ V4c ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
          & ( V5y != fo__c_2Eextreal_2ENegInf ) )
       => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V4c ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V5y ) ) )
         != fo__c_2Eextreal_2EPosInf ) )
    & ! [V6c: tp__ty_2Erealax_2Ereal,V7y: tp__ty_2Eextreal_2Eextreal] :
        ( ( ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( inj__ty_2Erealax_2Ereal @ V6c ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
          & ( V7y != fo__c_2Eextreal_2EPosInf ) )
       => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V6c ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V7y ) ) )
         != fo__c_2Eextreal_2ENegInf ) ) ) ).

thf(conj_thm_2Eextreal_2Emul__not__infty2,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V0x != fo__c_2Eextreal_2EPosInf )
        & ( V1y != fo__c_2Eextreal_2ENegInf )
        & ( V1y != fo__c_2Eextreal_2EPosInf ) )
     => ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
         != fo__c_2Eextreal_2ENegInf )
        & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
         != fo__c_2Eextreal_2EPosInf ) ) ) ).

thf(conj_thm_2Eextreal_2Eadd__ldistrib__pos,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eadd__ldistrib__neg,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eadd__ldistrib__normal,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( ( V1y != fo__c_2Eextreal_2EPosInf )
          & ( V2z != fo__c_2Eextreal_2EPosInf ) )
        | ( ( V1y != fo__c_2Eextreal_2ENegInf )
          & ( V2z != fo__c_2Eextreal_2ENegInf ) ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eadd__ldistrib__normal2,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eadd__rdistrib__normal,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( ( V1y != fo__c_2Eextreal_2EPosInf )
          & ( V2z != fo__c_2Eextreal_2EPosInf ) )
        | ( ( V1y != fo__c_2Eextreal_2ENegInf )
          & ( V2z != fo__c_2Eextreal_2ENegInf ) ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eadd__rdistrib__normal2,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eadd__ldistrib,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
          & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
        | ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
          & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eadd__rdistrib,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
          & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
        | ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
          & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Emul__lneg,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Emul__rneg,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eneg__mul2,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eadd2__sub2,axiom,
    ! [V0a: tp__ty_2Eextreal_2Eextreal,V1b: tp__ty_2Eextreal_2Eextreal,V2c: tp__ty_2Eextreal_2Eextreal,V3d: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( ( V1b != fo__c_2Eextreal_2EPosInf )
          & ( V3d != fo__c_2Eextreal_2EPosInf ) )
        | ( ( V1b != fo__c_2Eextreal_2ENegInf )
          & ( V3d != fo__c_2Eextreal_2ENegInf ) ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V0a ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1b ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V2c ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3d ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0a ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2c ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1b ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3d ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__ldistrib,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V0x != fo__c_2Eextreal_2EPosInf )
        & ( V1y != fo__c_2Eextreal_2ENegInf )
        & ( V1y != fo__c_2Eextreal_2EPosInf )
        & ( V2z != fo__c_2Eextreal_2ENegInf )
        & ( V2z != fo__c_2Eextreal_2EPosInf ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esub__rdistrib,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V0x != fo__c_2Eextreal_2EPosInf )
        & ( V1y != fo__c_2Eextreal_2ENegInf )
        & ( V1y != fo__c_2Eextreal_2EPosInf )
        & ( V2z != fo__c_2Eextreal_2ENegInf )
        & ( V2z != fo__c_2Eextreal_2EPosInf ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eextreal__div__eq,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Erealax_2Ereal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ ( ap @ c_2Ereal_2E_2F @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Einv__one,axiom,
    ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__inv @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
    = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Einv__1over,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__inv @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ediv__one,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
      = V0x ) ).

thf(conj_thm_2Eextreal_2Einv__pos,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        & ( V0x != fo__c_2Eextreal_2EPosInf ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Erinv__uniq,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
     => ( V1y
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__inv @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elinv__uniq,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
     => ( V0x
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__inv @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__rdiv,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__ldiv,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__rdiv,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Erealax_2Ereal] :
      ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__ldiv,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Erealax_2Ereal] :
      ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elt__rdiv__neg,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Erealax_2Ereal] :
      ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
      <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ediv__add,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal,V2z: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V1y != fo__c_2Eextreal_2ENegInf )
        & ( V2z
         != ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__inv,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__inv @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Epow__0,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Epow__1,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) )
      = V0x ) ).

thf(conj_thm_2Eextreal_2Epow__2,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ).

thf(conj_thm_2Eextreal_2Epow__zero,axiom,
    ! [V0n: tp__ty_2Enum_2Enum,V1x: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
    <=> ( V1x
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Epow__zero__imp,axiom,
    ! [V0n: tp__ty_2Enum_2Enum,V1x: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Enum_2Enum @ V0n ) ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
     => ( V1x
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__pow2,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Epow__pos__le,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
     => ! [V1n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Epow__pos__lt,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1n: tp__ty_2Enum_2Enum] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Epow__le,axiom,
    ! [V0n: tp__ty_2Enum_2Enum,V1x: tp__ty_2Eextreal_2Eextreal,V2y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Epow__lt,axiom,
    ! [V0n: tp__ty_2Enum_2Enum,V1x: tp__ty_2Eextreal_2Eextreal,V2y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Epow__lt2,axiom,
    ! [V0n: tp__ty_2Enum_2Enum,V1x: tp__ty_2Eextreal_2Eextreal,V2y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V0n != fo__c_2Enum_2E0 )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Epow__le__mono,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1n: tp__ty_2Enum_2Enum,V2m: tp__ty_2Enum_2Enum] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Earithmetic_2E_3C_3D @ ( inj__ty_2Enum_2Enum @ V1n ) ) @ ( inj__ty_2Enum_2Enum @ V2m ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Enum_2Enum @ V2m ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Epow__pos__even,axiom,
    ! [V0n: tp__ty_2Enum_2Enum,V1x: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) )
      <=> ( p @ ( ap @ c_2Earithmetic_2EEVEN @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Epow__neg__odd,axiom,
    ! [V0n: tp__ty_2Enum_2Enum,V1x: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
      <=> ( p @ ( ap @ c_2Earithmetic_2EODD @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eadd__pow2,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Epow__add,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1n: tp__ty_2Enum_2Enum,V2m: tp__ty_2Enum_2Enum] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( inj__ty_2Enum_2Enum @ V1n ) ) @ ( inj__ty_2Enum_2Enum @ V2m ) ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Enum_2Enum @ V2m ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Epow__mul,axiom,
    ! [V0n: tp__ty_2Enum_2Enum,V1x: tp__ty_2Eextreal_2Eextreal,V2y: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) ) @ ( inj__ty_2Enum_2Enum @ V0n ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Epow__minus1,axiom,
    ! [V0n: tp__ty_2Enum_2Enum] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2A @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Epow__not__infty,axiom,
    ! [V0n: tp__ty_2Enum_2Enum,V1x: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( V1x != fo__c_2Eextreal_2ENegInf )
        & ( V1x != fo__c_2Eextreal_2EPosInf ) )
     => ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Enum_2Enum @ V0n ) ) )
         != fo__c_2Eextreal_2ENegInf )
        & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Enum_2Enum @ V0n ) ) )
         != fo__c_2Eextreal_2EPosInf ) ) ) ).

thf(conj_thm_2Eextreal_2Esqrt__pos__le,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__sqrt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esqrt__pos__lt,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__sqrt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Epow2__sqrt,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__sqrt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
        = V0x ) ) ).

thf(conj_thm_2Eextreal_2Esqrt__pow2,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( ap @ c_2Eextreal_2Eextreal__sqrt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) )
        = V0x )
    <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esqrt__mono__le,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__sqrt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__sqrt @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Elogr__not__infty,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1b: tp__ty_2Erealax_2Ereal] :
      ( ( ( V0x != fo__c_2Eextreal_2ENegInf )
        & ( V0x != fo__c_2Eextreal_2EPosInf ) )
     => ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__logr @ ( inj__ty_2Erealax_2Ereal @ V1b ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
         != fo__c_2Eextreal_2ENegInf )
        & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__logr @ ( inj__ty_2Erealax_2Ereal @ V1b ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
         != fo__c_2Eextreal_2EPosInf ) ) ) ).

thf(conj_thm_2Eextreal_2Ehalf__between,axiom,
    ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) )
    & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
    & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) )
    & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ethirds__between,axiom,
    ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) )
    & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
    & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) )
    & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
    & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) )
    & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
    & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) )
    & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ehalf__cancel,axiom,
    ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) )
    = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ethird__cancel,axiom,
    ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) )
    = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Efourth__cancel,axiom,
    ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) )
    = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Equotient__normal,axiom,
    ! [V0n: tp__ty_2Enum_2Enum,V1m: tp__ty_2Enum_2Enum] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__div @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ V1m ) ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ ( ap @ c_2Ereal_2E_2F @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ V1m ) ) ) ) ) ) ).

thf(ax_thm_2Eextreal_2Eext__mono__increasing__def,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
     => ( ( p @ ( ap @ c_2Eextreal_2Eext__mono__increasing @ V0f ) )
      <=> ! [V1m: tp__ty_2Enum_2Enum,V2n: tp__ty_2Enum_2Enum] :
            ( ( p @ ( ap @ ( ap @ c_2Earithmetic_2E_3C_3D @ ( inj__ty_2Enum_2Enum @ V1m ) ) @ ( inj__ty_2Enum_2Enum @ V2n ) ) )
           => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V1m ) ) ) @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eext__mono__increasing__suc,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
     => ( ( p @ ( ap @ c_2Eextreal_2Eext__mono__increasing @ V0f ) )
      <=> ! [V1n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) @ ( ap @ V0f @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) ) ) ) ) ).

thf(ax_thm_2Eextreal_2Eext__mono__decreasing__def,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
     => ( ( p @ ( ap @ c_2Eextreal_2Eext__mono__decreasing @ V0f ) )
      <=> ! [V1m: tp__ty_2Enum_2Enum,V2n: tp__ty_2Enum_2Enum] :
            ( ( p @ ( ap @ ( ap @ c_2Earithmetic_2E_3C_3D @ ( inj__ty_2Enum_2Enum @ V1m ) ) @ ( inj__ty_2Enum_2Enum @ V2n ) ) )
           => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V1m ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eext__mono__decreasing__suc,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
     => ( ( p @ ( ap @ c_2Eextreal_2Eext__mono__decreasing @ V0f ) )
      <=> ! [V1n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ V0f @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) ) @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__ARCH,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
     => ! [V1y: tp__ty_2Eextreal_2Eextreal] :
          ( ( V1y != fo__c_2Eextreal_2EPosInf )
         => ? [V2n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2ESIMP__REAL__ARCH,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal] :
    ? [V1n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) ) ).

thf(conj_thm_2Eextreal_2ESIMP__REAL__ARCH__NEG,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal] :
    ? [V1n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ c_2Erealax_2Ereal__neg @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) ).

thf(conj_thm_2Eextreal_2ESIMP__EXTREAL__ARCH,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( V0x != fo__c_2Eextreal_2EPosInf )
     => ? [V1n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EREAL__ARCH__POW,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal] :
    ? [V1n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__ARCH__POW,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( V0x != fo__c_2Eextreal_2EPosInf )
     => ? [V1n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__pow @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__ARCH__POW__INV,axiom,
    ! [V0e: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0e ) ) )
     => ? [V1n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ ( ap @ c_2Ereal_2E_2F @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0e ) ) ) ) ).

thf(conj_thm_2Eextreal_2EREAL__LE__MUL__EPSILON,axiom,
    ! [V0x: tp__ty_2Erealax_2Ereal,V1y: tp__ty_2Erealax_2Ereal] :
      ( ! [V2z: tp__ty_2Erealax_2Ereal] :
          ( ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) )
            & ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) )
         => ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ ( ap @ c_2Erealax_2Ereal__mul @ ( inj__ty_2Erealax_2Ereal @ V2z ) ) @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( inj__ty_2Erealax_2Ereal @ V0x ) ) @ ( inj__ty_2Erealax_2Ereal @ V1y ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__epsilon,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ! [V2e: tp__ty_2Eextreal_2Eextreal] :
          ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2e ) ) )
            & ( V2e != fo__c_2Eextreal_2EPosInf ) )
         => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2e ) ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__mul__epsilon,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ! [V2z: tp__ty_2Eextreal_2Eextreal] :
          ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) )
            & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) )
         => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ).

thf(ax_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__DEF,axiom,
    ! [A_27a: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
     => ! [V1s: $i] :
          ( ( mem @ V1s @ ( arr @ A_27a @ bool ) )
         => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V0f ) @ V1s ) )
            = ( surj__ty_2Eextreal_2Eextreal
              @ ( ap
                @ ( ap
                  @ ( ap @ ( c_2Epred__set_2EITSET @ A_27a @ ty_2Eextreal_2Eextreal )
                    @ ( lam @ A_27a
                      @ ^ [V2e: $i] :
                          ( lam @ ty_2Eextreal_2Eextreal
                          @ ^ [V3acc: $i] : ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ V0f @ V2e ) ) @ V3acc ) ) ) )
                  @ V1s )
                @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__THM,axiom,
    ! [A_27a: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
     => ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V0f ) @ ( c_2Epred__set_2EEMPTY @ A_27a ) ) )
          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
        & ! [V1e: $i] :
            ( ( mem @ V1e @ A_27a )
           => ! [V2s: $i] :
                ( ( mem @ V2s @ ( arr @ A_27a @ bool ) )
               => ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V2s ) )
                 => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V0f ) @ ( ap @ ( ap @ ( c_2Epred__set_2EINSERT @ A_27a ) @ V1e ) @ V2s ) ) )
                    = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ V0f @ V1e ) ) @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V0f ) @ ( ap @ ( ap @ ( c_2Epred__set_2EDELETE @ A_27a ) @ V2s ) @ V1e ) ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__NOT__NEG__INF,axiom,
    ! [A_27a: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
     => ! [V1s: $i] :
          ( ( mem @ V1s @ ( arr @ A_27a @ bool ) )
         => ( ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V1s ) )
              & ! [V2x: $i] :
                  ( ( mem @ V2x @ A_27a )
                 => ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V2x ) @ V1s ) )
                   => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ V0f @ V2x ) )
                     != fo__c_2Eextreal_2ENegInf ) ) ) )
           => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V0f ) @ V1s ) )
             != fo__c_2Eextreal_2ENegInf ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__NOT__POS__INF,axiom,
    ! [A_27a: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
     => ! [V1s: $i] :
          ( ( mem @ V1s @ ( arr @ A_27a @ bool ) )
         => ( ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V1s ) )
              & ! [V2x: $i] :
                  ( ( mem @ V2x @ A_27a )
                 => ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V2x ) @ V1s ) )
                   => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ V0f @ V2x ) )
                     != fo__c_2Eextreal_2EPosInf ) ) ) )
           => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V0f ) @ V1s ) )
             != fo__c_2Eextreal_2EPosInf ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__NOT__INFTY,axiom,
    ! [A_27a: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
     => ! [V1s: $i] :
          ( ( mem @ V1s @ ( arr @ A_27a @ bool ) )
         => ( ( ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V1s ) )
                & ! [V2x: $i] :
                    ( ( mem @ V2x @ A_27a )
                   => ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V2x ) @ V1s ) )
                     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ V0f @ V2x ) )
                       != fo__c_2Eextreal_2ENegInf ) ) ) )
             => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V0f ) @ V1s ) )
               != fo__c_2Eextreal_2ENegInf ) )
            & ( ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V1s ) )
                & ! [V3x: $i] :
                    ( ( mem @ V3x @ A_27a )
                   => ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V3x ) @ V1s ) )
                     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ V0f @ V3x ) )
                       != fo__c_2Eextreal_2EPosInf ) ) ) )
             => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V0f ) @ V1s ) )
               != fo__c_2Eextreal_2EPosInf ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__SING,axiom,
    ! [A_27a: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
     => ! [V1e: $i] :
          ( ( mem @ V1e @ A_27a )
         => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V0f ) @ ( ap @ ( ap @ ( c_2Epred__set_2EINSERT @ A_27a ) @ V1e ) @ ( c_2Epred__set_2EEMPTY @ A_27a ) ) ) )
            = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ V0f @ V1e ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__POS,axiom,
    ! [A_27a: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
     => ! [V1s: $i] :
          ( ( mem @ V1s @ ( arr @ A_27a @ bool ) )
         => ( ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V1s ) )
              & ! [V2x: $i] :
                  ( ( mem @ V2x @ A_27a )
                 => ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V2x ) @ V1s ) )
                   => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ V0f @ V2x ) ) ) ) ) )
           => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V0f ) @ V1s ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__SPOS,axiom,
    ! [A_27a: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
     => ! [V1s: $i] :
          ( ( mem @ V1s @ ( arr @ A_27a @ bool ) )
         => ( ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V1s ) )
              & ( V1s
               != ( c_2Epred__set_2EEMPTY @ A_27a ) )
              & ! [V2x: $i] :
                  ( ( mem @ V2x @ A_27a )
                 => ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V2x ) @ V1s ) )
                   => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ V0f @ V2x ) ) ) ) ) )
           => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V0f ) @ V1s ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__IF__ELIM,axiom,
    ! [A_27a: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ! [V1P: $i] :
          ( ( mem @ V1P @ ( arr @ A_27a @ bool ) )
         => ! [V2f: $i] :
              ( ( mem @ V2f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
             => ( ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V0s ) )
                  & ! [V3x: $i] :
                      ( ( mem @ V3x @ A_27a )
                     => ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V3x ) @ V0s ) )
                       => ( p @ ( ap @ V1P @ V3x ) ) ) ) )
               => ( ( surj__ty_2Eextreal_2Eextreal
                    @ ( ap
                      @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a )
                        @ ( lam @ A_27a
                          @ ^ [V4x: $i] : ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Eextreal_2Eextreal ) @ ( ap @ V1P @ V4x ) ) @ ( ap @ V2f @ V4x ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
                      @ V0s ) )
                  = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V2f ) @ V0s ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__FINITE__SAME,axiom,
    ! [A_27a: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V0s ) )
       => ! [V1f: $i] :
            ( ( mem @ V1f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
           => ! [V2p: $i] :
                ( ( mem @ V2p @ A_27a )
               => ( ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V2p ) @ V0s ) )
                    & ! [V3q: $i] :
                        ( ( mem @ V3q @ A_27a )
                       => ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V3q ) @ V0s ) )
                         => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ V1f @ V2p ) )
                            = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ V1f @ V3q ) ) ) ) ) )
                 => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V1f ) @ V0s ) )
                    = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ ( c_2Epred__set_2ECARD @ A_27a ) @ V0s ) ) ) @ ( ap @ V1f @ V2p ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__FINITE__CONST,axiom,
    ! [A_27a: del,V0P: $i] :
      ( ( mem @ V0P @ ( arr @ A_27a @ bool ) )
     => ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V0P ) )
       => ! [V1f: $i] :
            ( ( mem @ V1f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
           => ! [V2x: tp__ty_2Eextreal_2Eextreal] :
                ( ! [V3y: $i] :
                    ( ( mem @ V3y @ A_27a )
                   => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ V1f @ V3y ) )
                      = V2x ) )
               => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V1f ) @ V0P ) )
                  = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ ( c_2Epred__set_2ECARD @ A_27a ) @ V0P ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2x ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__ZERO,axiom,
    ! [A_27a: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V0s ) )
       => ( ( surj__ty_2Eextreal_2Eextreal
            @ ( ap
              @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a )
                @ ( lam @ A_27a
                  @ ^ [V1x: $i] : ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
              @ V0s ) )
          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__0,axiom,
    ! [A_27a: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
     => ! [V1s: $i] :
          ( ( mem @ V1s @ ( arr @ A_27a @ bool ) )
         => ( ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V1s ) )
              & ! [V2x: $i] :
                  ( ( mem @ V2x @ A_27a )
                 => ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V2x ) @ V1s ) )
                   => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ V0f @ V2x ) )
                      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ) )
           => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V0f ) @ V1s ) )
              = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__IN__IF,axiom,
    ! [A_27a: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V0s ) )
       => ! [V1f: $i] :
            ( ( mem @ V1f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
           => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V1f ) @ V0s ) )
              = ( surj__ty_2Eextreal_2Eextreal
                @ ( ap
                  @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a )
                    @ ( lam @ A_27a
                      @ ^ [V2x: $i] : ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Eextreal_2Eextreal ) @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V2x ) @ V0s ) ) @ ( ap @ V1f @ V2x ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
                  @ V0s ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__CMUL,axiom,
    ! [A_27a: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V0s ) )
       => ! [V1f: $i] :
            ( ( mem @ V1f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
           => ! [V2c: tp__ty_2Erealax_2Ereal] :
                ( ( ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V2c ) ) )
                  | ! [V3x: $i] :
                      ( ( mem @ V3x @ A_27a )
                     => ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V3x ) @ V0s ) )
                       => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ V1f @ V3x ) ) ) ) ) )
               => ( ( surj__ty_2Eextreal_2Eextreal
                    @ ( ap
                      @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a )
                        @ ( lam @ A_27a
                          @ ^ [V4x: $i] : ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V2c ) ) ) @ ( ap @ V1f @ V4x ) ) ) )
                      @ V0s ) )
                  = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V2c ) ) ) @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V1f ) @ V0s ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__CMUL2,axiom,
    ! [A_27a: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ! [V1f: $i] :
          ( ( mem @ V1f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
         => ! [V2c: tp__ty_2Erealax_2Ereal] :
              ( ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V0s ) )
                & ! [V3x: $i] :
                    ( ( mem @ V3x @ A_27a )
                   => ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V3x ) @ V0s ) )
                     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ V1f @ V3x ) )
                       != fo__c_2Eextreal_2ENegInf ) ) ) )
             => ( ( surj__ty_2Eextreal_2Eextreal
                  @ ( ap
                    @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a )
                      @ ( lam @ A_27a
                        @ ^ [V4x: $i] : ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V2c ) ) ) @ ( ap @ V1f @ V4x ) ) ) )
                    @ V0s ) )
                = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V2c ) ) ) @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V1f ) @ V0s ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__IMAGE,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V0s ) )
       => ! [V1f_27: $i] :
            ( ( mem @ V1f_27 @ ( arr @ A_27a @ A_27b ) )
           => ( ( p @ ( ap @ ( ap @ ( ap @ ( c_2Epred__set_2EINJ @ A_27a @ A_27b ) @ V1f_27 ) @ V0s ) @ ( ap @ ( ap @ ( c_2Epred__set_2EIMAGE @ A_27a @ A_27b ) @ V1f_27 ) @ V0s ) ) )
             => ! [V2f: $i] :
                  ( ( mem @ V2f @ ( arr @ A_27b @ ty_2Eextreal_2Eextreal ) )
                 => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27b ) @ V2f ) @ ( ap @ ( ap @ ( c_2Epred__set_2EIMAGE @ A_27a @ A_27b ) @ V1f_27 ) @ V0s ) ) )
                    = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Eextreal_2Eextreal @ A_27b ) @ V2f ) @ V1f_27 ) ) @ V0s ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__DISJOINT__UNION,axiom,
    ! [A_27a: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ! [V1s_27: $i] :
          ( ( mem @ V1s_27 @ ( arr @ A_27a @ bool ) )
         => ( ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V0s ) )
              & ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V1s_27 ) )
              & ( p @ ( ap @ ( ap @ ( c_2Epred__set_2EDISJOINT @ A_27a ) @ V0s ) @ V1s_27 ) ) )
           => ! [V2f: $i] :
                ( ( mem @ V2f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
               => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V2f ) @ ( ap @ ( ap @ ( c_2Epred__set_2EUNION @ A_27a ) @ V0s ) @ V1s_27 ) ) )
                  = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V2f ) @ V0s ) ) @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V2f ) @ V1s_27 ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__EQ__CARD,axiom,
    ! [A_27a: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V0s ) )
       => ( ( surj__ty_2Eextreal_2Eextreal
            @ ( ap
              @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a )
                @ ( lam @ A_27a
                  @ ^ [V1x: $i] : ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Eextreal_2Eextreal ) @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V1x ) @ V0s ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
              @ V0s ) )
          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ ( c_2Epred__set_2ECARD @ A_27a ) @ V0s ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__INV__CARD__EQ__1,axiom,
    ! [A_27a: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ( ( ( V0s
           != ( c_2Epred__set_2EEMPTY @ A_27a ) )
          & ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V0s ) ) )
       => ( ( surj__ty_2Eextreal_2Eextreal
            @ ( ap
              @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a )
                @ ( lam @ A_27a
                  @ ^ [V1x: $i] : ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Eextreal_2Eextreal ) @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V1x ) @ V0s ) ) @ ( ap @ c_2Eextreal_2Eextreal__inv @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ ( c_2Epred__set_2ECARD @ A_27a ) @ V0s ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
              @ V0s ) )
          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__INTER__NONZERO,axiom,
    ! [A_27a: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V0s ) )
       => ! [V1f: $i] :
            ( ( mem @ V1f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
           => ( ( surj__ty_2Eextreal_2Eextreal
                @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V1f )
                  @ ( ap @ ( ap @ ( c_2Epred__set_2EINTER @ A_27a ) @ V0s )
                    @ ( lam @ A_27a
                      @ ^ [V2p: $i] : ( ap @ c_2Ebool_2E_7E @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Eextreal_2Eextreal ) @ ( ap @ V1f @ V2p ) ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ) ) )
              = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V1f ) @ V0s ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__INTER__ELIM,axiom,
    ! [A_27a: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V0s ) )
       => ! [V1f: $i] :
            ( ( mem @ V1f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
           => ! [V2s_27: $i] :
                ( ( mem @ V2s_27 @ ( arr @ A_27a @ bool ) )
               => ( ! [V3x: $i] :
                      ( ( mem @ V3x @ A_27a )
                     => ( ~ ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V3x ) @ V2s_27 ) )
                       => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ V1f @ V3x ) )
                          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) )
                 => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V1f ) @ ( ap @ ( ap @ ( c_2Epred__set_2EINTER @ A_27a ) @ V0s ) @ V2s_27 ) ) )
                    = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V1f ) @ V0s ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__ZERO__DIFF,axiom,
    ! [A_27a: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V0s ) )
       => ! [V1f: $i] :
            ( ( mem @ V1f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
           => ! [V2t: $i] :
                ( ( mem @ V2t @ ( arr @ A_27a @ bool ) )
               => ( ! [V3x: $i] :
                      ( ( mem @ V3x @ A_27a )
                     => ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V3x ) @ V2t ) )
                       => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ V1f @ V3x ) )
                          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) )
                 => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V1f ) @ V0s ) )
                    = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V1f ) @ ( ap @ ( ap @ ( c_2Epred__set_2EDIFF @ A_27a ) @ V0s ) @ V2t ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__MONO,axiom,
    ! [A_27a: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V0s ) )
       => ! [V1f: $i] :
            ( ( mem @ V1f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
           => ! [V2f_27: $i] :
                ( ( mem @ V2f_27 @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
               => ( ! [V3x: $i] :
                      ( ( mem @ V3x @ A_27a )
                     => ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V3x ) @ V0s ) )
                       => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ V1f @ V3x ) ) @ ( ap @ V2f_27 @ V3x ) ) ) ) )
                 => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V1f ) @ V0s ) ) @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V2f_27 ) @ V0s ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__MONO__SET,axiom,
    ! [A_27a: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
     => ! [V1s: $i] :
          ( ( mem @ V1s @ ( arr @ A_27a @ bool ) )
         => ! [V2t: $i] :
              ( ( mem @ V2t @ ( arr @ A_27a @ bool ) )
             => ( ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V1s ) )
                  & ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V2t ) )
                  & ( p @ ( ap @ ( ap @ ( c_2Epred__set_2ESUBSET @ A_27a ) @ V1s ) @ V2t ) )
                  & ! [V3x: $i] :
                      ( ( mem @ V3x @ A_27a )
                     => ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V3x ) @ V2t ) )
                       => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ V0f @ V3x ) ) ) ) ) )
               => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V0f ) @ V1s ) ) @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V0f ) @ V2t ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__EQ,axiom,
    ! [A_27a: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V0s ) )
       => ! [V1f: $i] :
            ( ( mem @ V1f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
           => ! [V2f_27: $i] :
                ( ( mem @ V2f_27 @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
               => ( ! [V3x: $i] :
                      ( ( mem @ V3x @ A_27a )
                     => ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V3x ) @ V0s ) )
                       => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ V1f @ V3x ) )
                          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ V2f_27 @ V3x ) ) ) ) )
                 => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V1f ) @ V0s ) )
                    = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V2f_27 ) @ V0s ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__POS__MEM__LE,axiom,
    ! [A_27a: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
     => ! [V1s: $i] :
          ( ( mem @ V1s @ ( arr @ A_27a @ bool ) )
         => ( ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V1s ) )
              & ! [V2x: $i] :
                  ( ( mem @ V2x @ A_27a )
                 => ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V2x ) @ V1s ) )
                   => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ V0f @ V2x ) ) ) ) ) )
           => ! [V3x: $i] :
                ( ( mem @ V3x @ A_27a )
               => ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V3x ) @ V1s ) )
                 => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ V0f @ V3x ) ) @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V0f ) @ V1s ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__ADD,axiom,
    ! [A_27a: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V0s ) )
       => ! [V1f: $i] :
            ( ( mem @ V1f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
           => ! [V2f_27: $i] :
                ( ( mem @ V2f_27 @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
               => ( ( surj__ty_2Eextreal_2Eextreal
                    @ ( ap
                      @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a )
                        @ ( lam @ A_27a
                          @ ^ [V3x: $i] : ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ V1f @ V3x ) ) @ ( ap @ V2f_27 @ V3x ) ) ) )
                      @ V0s ) )
                  = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V1f ) @ V0s ) ) @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V2f_27 ) @ V0s ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__SUB,axiom,
    ! [A_27a: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V0s ) )
       => ! [V1f: $i] :
            ( ( mem @ V1f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
           => ! [V2f_27: $i] :
                ( ( mem @ V2f_27 @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
               => ( ( ! [V3x: $i] :
                        ( ( mem @ V3x @ A_27a )
                       => ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V3x ) @ V0s ) )
                         => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ V2f_27 @ V3x ) )
                           != fo__c_2Eextreal_2ENegInf ) ) )
                    | ! [V4x: $i] :
                        ( ( mem @ V4x @ A_27a )
                       => ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V4x ) @ V0s ) )
                         => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ V2f_27 @ V4x ) )
                           != fo__c_2Eextreal_2EPosInf ) ) ) )
                 => ( ( surj__ty_2Eextreal_2Eextreal
                      @ ( ap
                        @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a )
                          @ ( lam @ A_27a
                            @ ^ [V5x: $i] : ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( ap @ V1f @ V5x ) ) @ ( ap @ V2f_27 @ V5x ) ) ) )
                        @ V0s ) )
                    = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V1f ) @ V0s ) ) @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V2f_27 ) @ V0s ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__EXTREAL__SUM__IMAGE,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ! [V1s_27: $i] :
          ( ( mem @ V1s_27 @ ( arr @ A_27b @ bool ) )
         => ! [V2f: $i] :
              ( ( mem @ V2f @ ( arr @ A_27a @ ( arr @ A_27b @ ty_2Eextreal_2Eextreal ) ) )
             => ( ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V0s ) )
                  & ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27b ) @ V1s_27 ) ) )
               => ( ( surj__ty_2Eextreal_2Eextreal
                    @ ( ap
                      @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a )
                        @ ( lam @ A_27a
                          @ ^ [V3x: $i] : ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27b ) @ ( ap @ V2f @ V3x ) ) @ V1s_27 ) ) )
                      @ V0s ) )
                  = ( surj__ty_2Eextreal_2Eextreal
                    @ ( ap
                      @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ ( ty_2Epair_2Eprod @ A_27a @ A_27b ) )
                        @ ( lam @ ( ty_2Epair_2Eprod @ A_27a @ A_27b )
                          @ ^ [V4x: $i] : ( ap @ ( ap @ V2f @ ( ap @ ( c_2Epair_2EFST @ A_27a @ A_27b ) @ V4x ) ) @ ( ap @ ( c_2Epair_2ESND @ A_27a @ A_27b ) @ V4x ) ) ) )
                      @ ( ap @ ( ap @ ( c_2Epred__set_2ECROSS @ A_27a @ A_27b ) @ V0s ) @ V1s_27 ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__NORMAL,axiom,
    ! [A_27a: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ A_27a @ ty_2Erealax_2Ereal ) )
     => ! [V1s: $i] :
          ( ( mem @ V1s @ ( arr @ A_27a @ bool ) )
         => ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V1s ) )
           => ( ( surj__ty_2Eextreal_2Eextreal
                @ ( ap
                  @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a )
                    @ ( lam @ A_27a
                      @ ^ [V2x: $i] : ( ap @ c_2Eextreal_2ENormal @ ( ap @ V0f @ V2x ) ) ) )
                  @ V1s ) )
              = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ ( ap @ ( c_2Ereal__sigma_2EREAL__SUM__IMAGE @ A_27a ) @ V0f ) @ V1s ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__IN__IF__ALT,axiom,
    ! [A_27a: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ! [V1f: $i] :
          ( ( mem @ V1f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
         => ! [V2z: tp__ty_2Eextreal_2Eextreal] :
              ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V0s ) )
             => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a ) @ V1f ) @ V0s ) )
                = ( surj__ty_2Eextreal_2Eextreal
                  @ ( ap
                    @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ A_27a )
                      @ ( lam @ A_27a
                        @ ^ [V3x: $i] : ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Eextreal_2Eextreal ) @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ A_27a ) @ V3x ) @ V0s ) ) @ ( ap @ V1f @ V3x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2z ) ) ) )
                    @ V0s ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__CROSS__SYM,axiom,
    ! [A_27a: del,A_27b: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ( ty_2Epair_2Eprod @ A_27a @ A_27b ) @ ty_2Eextreal_2Eextreal ) )
     => ! [V1s1: $i] :
          ( ( mem @ V1s1 @ ( arr @ A_27a @ bool ) )
         => ! [V2s2: $i] :
              ( ( mem @ V2s2 @ ( arr @ A_27b @ bool ) )
             => ( ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27a ) @ V1s1 ) )
                  & ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ A_27b ) @ V2s2 ) ) )
               => ( ( surj__ty_2Eextreal_2Eextreal
                    @ ( ap
                      @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ ( ty_2Epair_2Eprod @ A_27a @ A_27b ) )
                        @ ( ap @ ( c_2Epair_2EUNCURRY @ A_27a @ A_27b @ ty_2Eextreal_2Eextreal )
                          @ ( lam @ A_27a
                            @ ^ [V3x: $i] :
                                ( lam @ A_27b
                                @ ^ [V4y: $i] : ( ap @ V0f @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ A_27a @ A_27b ) @ V3x ) @ V4y ) ) ) ) ) )
                      @ ( ap @ ( ap @ ( c_2Epred__set_2ECROSS @ A_27a @ A_27b ) @ V1s1 ) @ V2s2 ) ) )
                  = ( surj__ty_2Eextreal_2Eextreal
                    @ ( ap
                      @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ ( ty_2Epair_2Eprod @ A_27b @ A_27a ) )
                        @ ( ap @ ( c_2Epair_2EUNCURRY @ A_27b @ A_27a @ ty_2Eextreal_2Eextreal )
                          @ ( lam @ A_27b
                            @ ^ [V5y: $i] :
                                ( lam @ A_27a
                                @ ^ [V6x: $i] : ( ap @ V0f @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ A_27a @ A_27b ) @ V6x ) @ V5y ) ) ) ) ) )
                      @ ( ap @ ( ap @ ( c_2Epred__set_2ECROSS @ A_27b @ A_27a ) @ V2s2 ) @ V1s1 ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2EEXTREAL__SUM__IMAGE__COUNT,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
     => ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ ty_2Enum_2Enum ) @ V0f ) @ ( ap @ c_2Epred__set_2Ecount @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ V0f @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) )
        & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ ty_2Enum_2Enum ) @ V0f ) @ ( ap @ c_2Epred__set_2Ecount @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) )
          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ V0f @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ V0f @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) )
        & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ ty_2Enum_2Enum ) @ V0f ) @ ( ap @ c_2Epred__set_2Ecount @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) )
          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ V0f @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ V0f @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ V0f @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) )
        & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ ty_2Enum_2Enum ) @ V0f ) @ ( ap @ c_2Epred__set_2Ecount @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) )
          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ V0f @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ V0f @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ V0f @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) @ ( ap @ V0f @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Eextreal_2Eextreal__sup__def,axiom,
    ! [V0p: $i] :
      ( ( mem @ V0p @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__sup @ V0p ) )
        = ( surj__ty_2Eextreal_2Eextreal
          @ ( ap
            @ ( ap
              @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Eextreal_2Eextreal )
                @ ( ap @ ( c_2Ebool_2E_21 @ ty_2Eextreal_2Eextreal )
                  @ ( lam @ ty_2Eextreal_2Eextreal
                    @ ^ [V1x: $i] :
                        ( ap
                        @ ( ap @ c_2Emin_2E_3D_3D_3E
                          @ ( ap @ ( c_2Ebool_2E_21 @ ty_2Eextreal_2Eextreal )
                            @ ( lam @ ty_2Eextreal_2Eextreal
                              @ ^ [V2y: $i] : ( ap @ ( ap @ c_2Emin_2E_3D_3D_3E @ ( ap @ V0p @ V2y ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ V2y ) @ V1x ) ) ) ) )
                        @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Eextreal_2Eextreal ) @ V1x ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) ) ) ) )
              @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) )
            @ ( ap
              @ ( ap
                @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Eextreal_2Eextreal )
                  @ ( ap @ ( c_2Ebool_2E_21 @ ty_2Eextreal_2Eextreal )
                    @ ( lam @ ty_2Eextreal_2Eextreal
                      @ ^ [V3x: $i] : ( ap @ ( ap @ c_2Emin_2E_3D_3D_3E @ ( ap @ V0p @ V3x ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Eextreal_2Eextreal ) @ V3x ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) ) ) ) )
                @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) )
              @ ( ap @ c_2Eextreal_2ENormal
                @ ( ap @ c_2Ereal_2Esup
                  @ ( lam @ ty_2Erealax_2Ereal
                    @ ^ [V4r: $i] : ( ap @ V0p @ ( ap @ c_2Eextreal_2ENormal @ V4r ) ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Eextreal_2Eextreal__inf__def,axiom,
    ! [V0p: $i] :
      ( ( mem @ V0p @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__inf @ V0p ) )
        = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__ainv @ ( ap @ c_2Eextreal_2Eextreal__sup @ ( ap @ ( ap @ ( c_2Epred__set_2EIMAGE @ ty_2Eextreal_2Eextreal @ ty_2Eextreal_2Eextreal ) @ c_2Eextreal_2Eextreal__ainv ) @ V0p ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__sup__imp,axiom,
    ! [V0p: $i] :
      ( ( mem @ V0p @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ! [V1x: tp__ty_2Eextreal_2Eextreal] :
          ( ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) )
         => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( ap @ c_2Eextreal_2Eextreal__sup @ V0p ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esup__le,axiom,
    ! [V0p: $i] :
      ( ( mem @ V0p @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ! [V1x: tp__ty_2Eextreal_2Eextreal] :
          ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__sup @ V0p ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) )
        <=> ! [V2y: tp__ty_2Eextreal_2Eextreal] :
              ( ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) )
             => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__sup,axiom,
    ! [V0p: $i] :
      ( ( mem @ V0p @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ! [V1x: tp__ty_2Eextreal_2Eextreal] :
          ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( ap @ c_2Eextreal_2Eextreal__sup @ V0p ) ) )
        <=> ! [V2y: tp__ty_2Eextreal_2Eextreal] :
              ( ! [V3z: tp__ty_2Eextreal_2Eextreal] :
                  ( ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V3z ) ) )
                 => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V3z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) ) )
             => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esup__eq,axiom,
    ! [V0p: $i] :
      ( ( mem @ V0p @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ! [V1x: tp__ty_2Eextreal_2Eextreal] :
          ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__sup @ V0p ) )
            = V1x )
        <=> ( ! [V2y: tp__ty_2Eextreal_2Eextreal] :
                ( ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) )
               => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) ) )
            & ! [V3y: tp__ty_2Eextreal_2Eextreal] :
                ( ! [V4z: tp__ty_2Eextreal_2Eextreal] :
                    ( ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V4z ) ) )
                   => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V4z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3y ) ) ) )
               => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3y ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esup__const,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal
        @ ( ap @ c_2Eextreal_2Eextreal__sup
          @ ( lam @ ty_2Eextreal_2Eextreal
            @ ^ [V1y: $i] : ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Eextreal_2Eextreal ) @ V1y ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) )
      = V0x ) ).

thf(conj_thm_2Eextreal_2Esup__const__alt,axiom,
    ! [V0p: $i] :
      ( ( mem @ V0p @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ! [V1z: tp__ty_2Eextreal_2Eextreal] :
          ( ( ? [V2x: tp__ty_2Eextreal_2Eextreal] : ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V2x ) ) )
            & ! [V3x: tp__ty_2Eextreal_2Eextreal] :
                ( ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V3x ) ) )
               => ( V3x = V1z ) ) )
         => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__sup @ V0p ) )
            = V1z ) ) ) ).

thf(conj_thm_2Eextreal_2Esup__const__over__set,axiom,
    ! [A_27a: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ! [V1k: tp__ty_2Eextreal_2Eextreal] :
          ( ( V0s
           != ( c_2Epred__set_2EEMPTY @ A_27a ) )
         => ( ( surj__ty_2Eextreal_2Eextreal
              @ ( ap @ c_2Eextreal_2Eextreal__sup
                @ ( ap
                  @ ( ap @ ( c_2Epred__set_2EIMAGE @ A_27a @ ty_2Eextreal_2Eextreal )
                    @ ( lam @ A_27a
                      @ ^ [V2x: $i] : ( inj__ty_2Eextreal_2Eextreal @ V1k ) ) )
                  @ V0s ) ) )
            = V1k ) ) ) ).

thf(conj_thm_2Eextreal_2Esup__num,axiom,
    ( ( surj__ty_2Eextreal_2Eextreal
      @ ( ap @ c_2Eextreal_2Eextreal__sup
        @ ( lam @ ty_2Eextreal_2Eextreal
          @ ^ [V0x: $i] :
              ( ap @ ( c_2Ebool_2E_3F @ ty_2Enum_2Enum )
              @ ( lam @ ty_2Enum_2Enum
                @ ^ [V1n: $i] : ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Eextreal_2Eextreal ) @ V0x ) @ ( ap @ c_2Eextreal_2Eextreal__of__num @ V1n ) ) ) ) ) ) )
    = fo__c_2Eextreal_2EPosInf ) ).

thf(conj_thm_2Eextreal_2Esup__le__sup__imp,axiom,
    ! [V0p: $i] :
      ( ( mem @ V0p @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ! [V1q: $i] :
          ( ( mem @ V1q @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
         => ( ! [V2x: tp__ty_2Eextreal_2Eextreal] :
                ( ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V2x ) ) )
               => ? [V3y: tp__ty_2Eextreal_2Eextreal] :
                    ( ( p @ ( ap @ V1q @ ( inj__ty_2Eextreal_2Eextreal @ V3y ) ) )
                    & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V2x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3y ) ) ) ) )
           => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__sup @ V0p ) ) @ ( ap @ c_2Eextreal_2Eextreal__sup @ V1q ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esup__mono,axiom,
    ! [V0p: $i] :
      ( ( mem @ V0p @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
     => ! [V1q: $i] :
          ( ( mem @ V1q @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
         => ( ! [V2n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ V0p @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) @ ( ap @ V1q @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) )
           => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__sup @ ( ap @ ( ap @ ( c_2Epred__set_2EIMAGE @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) @ V0p ) @ ( c_2Epred__set_2EUNIV @ ty_2Enum_2Enum ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__sup @ ( ap @ ( ap @ ( c_2Epred__set_2EIMAGE @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) @ V1q ) @ ( c_2Epred__set_2EUNIV @ ty_2Enum_2Enum ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esup__suc,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
     => ( ! [V1m: tp__ty_2Enum_2Enum,V2n: tp__ty_2Enum_2Enum] :
            ( ( p @ ( ap @ ( ap @ c_2Earithmetic_2E_3C_3D @ ( inj__ty_2Enum_2Enum @ V1m ) ) @ ( inj__ty_2Enum_2Enum @ V2n ) ) )
           => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V1m ) ) ) @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) ) )
       => ( ( surj__ty_2Eextreal_2Eextreal
            @ ( ap @ c_2Eextreal_2Eextreal__sup
              @ ( ap
                @ ( ap @ ( c_2Epred__set_2EIMAGE @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal )
                  @ ( lam @ ty_2Enum_2Enum
                    @ ^ [V3n: $i] : ( ap @ V0f @ ( ap @ c_2Enum_2ESUC @ V3n ) ) ) )
                @ ( c_2Epred__set_2EUNIV @ ty_2Enum_2Enum ) ) ) )
          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__sup @ ( ap @ ( ap @ ( c_2Epred__set_2EIMAGE @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) @ V0f ) @ ( c_2Epred__set_2EUNIV @ ty_2Enum_2Enum ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esup__seq,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Erealax_2Ereal ) )
     => ! [V1l: tp__ty_2Erealax_2Ereal] :
          ( ( p @ ( ap @ c_2Eextreal_2Emono__increasing @ V0f ) )
         => ( ( p @ ( ap @ ( ap @ c_2Eseq_2E_2D_2D_3E @ V0f ) @ ( inj__ty_2Erealax_2Ereal @ V1l ) ) )
          <=> ( ( surj__ty_2Eextreal_2Eextreal
                @ ( ap @ c_2Eextreal_2Eextreal__sup
                  @ ( ap
                    @ ( ap @ ( c_2Epred__set_2EIMAGE @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal )
                      @ ( lam @ ty_2Enum_2Enum
                        @ ^ [V2n: $i] : ( ap @ c_2Eextreal_2ENormal @ ( ap @ V0f @ V2n ) ) ) )
                    @ ( c_2Epred__set_2EUNIV @ ty_2Enum_2Enum ) ) ) )
              = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1l ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esup__lt__infty,axiom,
    ! [V0p: $i] :
      ( ( mem @ V0p @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__sup @ V0p ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
       => ! [V1x: tp__ty_2Eextreal_2Eextreal] :
            ( ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) )
           => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esup__max,axiom,
    ! [V0p: $i] :
      ( ( mem @ V0p @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ! [V1z: tp__ty_2Eextreal_2Eextreal] :
          ( ( ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V1z ) ) )
            & ! [V2x: tp__ty_2Eextreal_2Eextreal] :
                ( ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V2x ) ) )
               => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V2x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1z ) ) ) ) )
         => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__sup @ V0p ) )
            = V1z ) ) ) ).

thf(conj_thm_2Eextreal_2Esup__add__mono,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
     => ! [V1g: $i] :
          ( ( mem @ V1g @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
         => ( ( ! [V2n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) )
              & ! [V3n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V3n ) ) ) @ ( ap @ V0f @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ V3n ) ) ) ) )
              & ! [V4n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ V1g @ ( inj__ty_2Enum_2Enum @ V4n ) ) ) )
              & ! [V5n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ V1g @ ( inj__ty_2Enum_2Enum @ V5n ) ) ) @ ( ap @ V1g @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ V5n ) ) ) ) ) )
           => ( ( surj__ty_2Eextreal_2Eextreal
                @ ( ap @ c_2Eextreal_2Eextreal__sup
                  @ ( ap
                    @ ( ap @ ( c_2Epred__set_2EIMAGE @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal )
                      @ ( lam @ ty_2Enum_2Enum
                        @ ^ [V6n: $i] : ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ V0f @ V6n ) ) @ ( ap @ V1g @ V6n ) ) ) )
                    @ ( c_2Epred__set_2EUNIV @ ty_2Enum_2Enum ) ) ) )
              = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ c_2Eextreal_2Eextreal__sup @ ( ap @ ( ap @ ( c_2Epred__set_2EIMAGE @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) @ V0f ) @ ( c_2Epred__set_2EUNIV @ ty_2Enum_2Enum ) ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__sup @ ( ap @ ( ap @ ( c_2Epred__set_2EIMAGE @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) @ V1g ) @ ( c_2Epred__set_2EUNIV @ ty_2Enum_2Enum ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esup__sum__mono,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) ) )
     => ! [V1s: $i] :
          ( ( mem @ V1s @ ( arr @ ty_2Enum_2Enum @ bool ) )
         => ( ( ( p @ ( ap @ ( c_2Epred__set_2EFINITE @ ty_2Enum_2Enum ) @ V1s ) )
              & ! [V2i: tp__ty_2Enum_2Enum] :
                  ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ ty_2Enum_2Enum ) @ ( inj__ty_2Enum_2Enum @ V2i ) ) @ V1s ) )
                 => ! [V3n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V2i ) ) @ ( inj__ty_2Enum_2Enum @ V3n ) ) ) ) )
              & ! [V4i: tp__ty_2Enum_2Enum] :
                  ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ ty_2Enum_2Enum ) @ ( inj__ty_2Enum_2Enum @ V4i ) ) @ V1s ) )
                 => ! [V5n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V4i ) ) @ ( inj__ty_2Enum_2Enum @ V5n ) ) ) @ ( ap @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V4i ) ) @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ V5n ) ) ) ) ) ) )
           => ( ( surj__ty_2Eextreal_2Eextreal
                @ ( ap @ c_2Eextreal_2Eextreal__sup
                  @ ( ap
                    @ ( ap @ ( c_2Epred__set_2EIMAGE @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal )
                      @ ( lam @ ty_2Enum_2Enum
                        @ ^ [V6n: $i] :
                            ( ap
                            @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ ty_2Enum_2Enum )
                              @ ( lam @ ty_2Enum_2Enum
                                @ ^ [V7i: $i] : ( ap @ ( ap @ V0f @ V7i ) @ V6n ) ) )
                            @ V1s ) ) )
                    @ ( c_2Epred__set_2EUNIV @ ty_2Enum_2Enum ) ) ) )
              = ( surj__ty_2Eextreal_2Eextreal
                @ ( ap
                  @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ ty_2Enum_2Enum )
                    @ ( lam @ ty_2Enum_2Enum
                      @ ^ [V8i: $i] : ( ap @ c_2Eextreal_2Eextreal__sup @ ( ap @ ( ap @ ( c_2Epred__set_2EIMAGE @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) @ ( ap @ V0f @ V8i ) ) @ ( c_2Epred__set_2EUNIV @ ty_2Enum_2Enum ) ) ) ) )
                  @ V1s ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esup__le__mono,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
     => ! [V1z: tp__ty_2Eextreal_2Eextreal] :
          ( ( ! [V2n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) @ ( ap @ V0f @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) ) )
            & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1z ) ) @ ( ap @ c_2Eextreal_2Eextreal__sup @ ( ap @ ( ap @ ( c_2Epred__set_2EIMAGE @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) @ V0f ) @ ( c_2Epred__set_2EUNIV @ ty_2Enum_2Enum ) ) ) ) ) )
         => ? [V3n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1z ) ) @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V3n ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esup__cmul,axiom,
    ! [A_27a: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
     => ! [V1c: tp__ty_2Erealax_2Ereal] :
          ( ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V1c ) ) )
         => ( ( surj__ty_2Eextreal_2Eextreal
              @ ( ap @ c_2Eextreal_2Eextreal__sup
                @ ( ap
                  @ ( ap @ ( c_2Epred__set_2EIMAGE @ A_27a @ ty_2Eextreal_2Eextreal )
                    @ ( lam @ A_27a
                      @ ^ [V2n: $i] : ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1c ) ) ) @ ( ap @ V0f @ V2n ) ) ) )
                  @ ( c_2Epred__set_2EUNIV @ A_27a ) ) ) )
            = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1c ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__sup @ ( ap @ ( ap @ ( c_2Epred__set_2EIMAGE @ A_27a @ ty_2Eextreal_2Eextreal ) @ V0f ) @ ( c_2Epred__set_2EUNIV @ A_27a ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esup__lt,axiom,
    ! [V0P: $i] :
      ( ( mem @ V0P @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ! [V1y: tp__ty_2Eextreal_2Eextreal] :
          ( ? [V2x: tp__ty_2Eextreal_2Eextreal] :
              ( ( p @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ V2x ) ) )
              & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2x ) ) ) )
        <=> ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ c_2Eextreal_2Eextreal__sup @ V0P ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Esup__lt__epsilon,axiom,
    ! [V0P: $i] :
      ( ( mem @ V0P @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ! [V1e: tp__ty_2Eextreal_2Eextreal] :
          ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1e ) ) )
            & ? [V2x: tp__ty_2Eextreal_2Eextreal] :
                ( ( p @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ V2x ) ) )
                & ( V2x != fo__c_2Eextreal_2ENegInf ) )
            & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__sup @ V0P ) )
             != fo__c_2Eextreal_2EPosInf ) )
         => ? [V3x: tp__ty_2Eextreal_2Eextreal] :
              ( ( p @ ( ap @ V0P @ ( inj__ty_2Eextreal_2Eextreal @ V3x ) ) )
              & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ c_2Eextreal_2Eextreal__sup @ V0P ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( inj__ty_2Eextreal_2Eextreal @ V3x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1e ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Einf__le__imp,axiom,
    ! [V0p: $i] :
      ( ( mem @ V0p @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ! [V1x: tp__ty_2Eextreal_2Eextreal] :
          ( ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) )
         => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__inf @ V0p ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__inf,axiom,
    ! [V0p: $i] :
      ( ( mem @ V0p @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ! [V1x: tp__ty_2Eextreal_2Eextreal] :
          ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( ap @ c_2Eextreal_2Eextreal__inf @ V0p ) ) )
        <=> ! [V2y: tp__ty_2Eextreal_2Eextreal] :
              ( ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) )
             => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Einf__le,axiom,
    ! [V0p: $i] :
      ( ( mem @ V0p @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ! [V1x: tp__ty_2Eextreal_2Eextreal] :
          ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__inf @ V0p ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) )
        <=> ! [V2y: tp__ty_2Eextreal_2Eextreal] :
              ( ! [V3z: tp__ty_2Eextreal_2Eextreal] :
                  ( ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V3z ) ) )
                 => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3z ) ) ) )
             => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Einf__eq,axiom,
    ! [V0p: $i] :
      ( ( mem @ V0p @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ! [V1x: tp__ty_2Eextreal_2Eextreal] :
          ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__inf @ V0p ) )
            = V1x )
        <=> ( ! [V2y: tp__ty_2Eextreal_2Eextreal] :
                ( ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) )
               => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) ) )
            & ! [V3y: tp__ty_2Eextreal_2Eextreal] :
                ( ! [V4z: tp__ty_2Eextreal_2Eextreal] :
                    ( ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V4z ) ) )
                   => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V3y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V4z ) ) ) )
               => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V3y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Einf__const,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal
        @ ( ap @ c_2Eextreal_2Eextreal__inf
          @ ( lam @ ty_2Eextreal_2Eextreal
            @ ^ [V1y: $i] : ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Eextreal_2Eextreal ) @ V1y ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) )
      = V0x ) ).

thf(conj_thm_2Eextreal_2Einf__const__alt,axiom,
    ! [V0p: $i] :
      ( ( mem @ V0p @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ! [V1z: tp__ty_2Eextreal_2Eextreal] :
          ( ( ? [V2x: tp__ty_2Eextreal_2Eextreal] : ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V2x ) ) )
            & ! [V3x: tp__ty_2Eextreal_2Eextreal] :
                ( ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V3x ) ) )
               => ( V3x = V1z ) ) )
         => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__inf @ V0p ) )
            = V1z ) ) ) ).

thf(conj_thm_2Eextreal_2Einf__const__over__set,axiom,
    ! [A_27a: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ A_27a @ bool ) )
     => ! [V1k: tp__ty_2Eextreal_2Eextreal] :
          ( ( V0s
           != ( c_2Epred__set_2EEMPTY @ A_27a ) )
         => ( ( surj__ty_2Eextreal_2Eextreal
              @ ( ap @ c_2Eextreal_2Eextreal__inf
                @ ( ap
                  @ ( ap @ ( c_2Epred__set_2EIMAGE @ A_27a @ ty_2Eextreal_2Eextreal )
                    @ ( lam @ A_27a
                      @ ^ [V2x: $i] : ( inj__ty_2Eextreal_2Eextreal @ V1k ) ) )
                  @ V0s ) ) )
            = V1k ) ) ) ).

thf(conj_thm_2Eextreal_2Einf__suc,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
     => ( ! [V1m: tp__ty_2Enum_2Enum,V2n: tp__ty_2Enum_2Enum] :
            ( ( p @ ( ap @ ( ap @ c_2Earithmetic_2E_3C_3D @ ( inj__ty_2Enum_2Enum @ V1m ) ) @ ( inj__ty_2Enum_2Enum @ V2n ) ) )
           => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V1m ) ) ) ) )
       => ( ( surj__ty_2Eextreal_2Eextreal
            @ ( ap @ c_2Eextreal_2Eextreal__inf
              @ ( ap
                @ ( ap @ ( c_2Epred__set_2EIMAGE @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal )
                  @ ( lam @ ty_2Enum_2Enum
                    @ ^ [V3n: $i] : ( ap @ V0f @ ( ap @ c_2Enum_2ESUC @ V3n ) ) ) )
                @ ( c_2Epred__set_2EUNIV @ ty_2Enum_2Enum ) ) ) )
          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__inf @ ( ap @ ( ap @ ( c_2Epred__set_2EIMAGE @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) @ V0f ) @ ( c_2Epred__set_2EUNIV @ ty_2Enum_2Enum ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Einf__seq,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Erealax_2Ereal ) )
     => ! [V1l: tp__ty_2Erealax_2Ereal] :
          ( ( p @ ( ap @ c_2Eextreal_2Emono__decreasing @ V0f ) )
         => ( ( p @ ( ap @ ( ap @ c_2Eseq_2E_2D_2D_3E @ V0f ) @ ( inj__ty_2Erealax_2Ereal @ V1l ) ) )
          <=> ( ( surj__ty_2Eextreal_2Eextreal
                @ ( ap @ c_2Eextreal_2Eextreal__inf
                  @ ( ap
                    @ ( ap @ ( c_2Epred__set_2EIMAGE @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal )
                      @ ( lam @ ty_2Enum_2Enum
                        @ ^ [V2n: $i] : ( ap @ c_2Eextreal_2ENormal @ ( ap @ V0f @ V2n ) ) ) )
                    @ ( c_2Epred__set_2EUNIV @ ty_2Enum_2Enum ) ) ) )
              = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1l ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Einf__lt__infty,axiom,
    ! [V0p: $i] :
      ( ( mem @ V0p @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( ap @ c_2Eextreal_2Eextreal__inf @ V0p ) ) )
       => ! [V1x: tp__ty_2Eextreal_2Eextreal] :
            ( ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) )
           => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Einf__min,axiom,
    ! [V0p: $i] :
      ( ( mem @ V0p @ ( arr @ ty_2Eextreal_2Eextreal @ bool ) )
     => ! [V1z: tp__ty_2Eextreal_2Eextreal] :
          ( ( ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V1z ) ) )
            & ! [V2x: tp__ty_2Eextreal_2Eextreal] :
                ( ( p @ ( ap @ V0p @ ( inj__ty_2Eextreal_2Eextreal @ V2x ) ) )
               => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2x ) ) ) ) )
         => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__inf @ V0p ) )
            = V1z ) ) ) ).

thf(conj_thm_2Eextreal_2Einf__cminus,axiom,
    ! [A_27a: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ A_27a @ ty_2Eextreal_2Eextreal ) )
     => ! [V1c: tp__ty_2Erealax_2Ereal] :
          ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1c ) ) ) @ ( ap @ c_2Eextreal_2Eextreal__inf @ ( ap @ ( ap @ ( c_2Epred__set_2EIMAGE @ A_27a @ ty_2Eextreal_2Eextreal ) @ V0f ) @ ( c_2Epred__set_2EUNIV @ A_27a ) ) ) ) )
          = ( surj__ty_2Eextreal_2Eextreal
            @ ( ap @ c_2Eextreal_2Eextreal__sup
              @ ( ap
                @ ( ap @ ( c_2Epred__set_2EIMAGE @ A_27a @ ty_2Eextreal_2Eextreal )
                  @ ( lam @ A_27a
                    @ ^ [V2n: $i] : ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1c ) ) ) @ ( ap @ V0f @ V2n ) ) ) )
                @ ( c_2Epred__set_2EUNIV @ A_27a ) ) ) ) ) ) ).

thf(ax_thm_2Eextreal_2Eext__suminf__def,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
     => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eext__suminf @ V0f ) )
        = ( surj__ty_2Eextreal_2Eextreal
          @ ( ap @ c_2Eextreal_2Eextreal__sup
            @ ( ap
              @ ( ap @ ( c_2Epred__set_2EIMAGE @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal )
                @ ( lam @ ty_2Enum_2Enum
                  @ ^ [V1n: $i] : ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ ty_2Enum_2Enum ) @ V0f ) @ ( ap @ c_2Epred__set_2Ecount @ V1n ) ) ) )
              @ ( c_2Epred__set_2EUNIV @ ty_2Enum_2Enum ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eext__suminf__add,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
     => ! [V1g: $i] :
          ( ( mem @ V1g @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
         => ( ! [V2n: tp__ty_2Enum_2Enum] :
                ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) )
                & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ V1g @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) ) )
           => ( ( surj__ty_2Eextreal_2Eextreal
                @ ( ap @ c_2Eextreal_2Eext__suminf
                  @ ( lam @ ty_2Enum_2Enum
                    @ ^ [V3n: $i] : ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ V0f @ V3n ) ) @ ( ap @ V1g @ V3n ) ) ) ) )
              = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__add @ ( ap @ c_2Eextreal_2Eext__suminf @ V0f ) ) @ ( ap @ c_2Eextreal_2Eext__suminf @ V1g ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eext__suminf__cmul,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
     => ! [V1c: tp__ty_2Eextreal_2Eextreal] :
          ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1c ) ) )
            & ! [V2n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) ) )
         => ( ( surj__ty_2Eextreal_2Eextreal
              @ ( ap @ c_2Eextreal_2Eext__suminf
                @ ( lam @ ty_2Enum_2Enum
                  @ ^ [V3n: $i] : ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V1c ) ) @ ( ap @ V0f @ V3n ) ) ) ) )
            = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( inj__ty_2Eextreal_2Eextreal @ V1c ) ) @ ( ap @ c_2Eextreal_2Eext__suminf @ V0f ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eext__suminf__cmul__alt,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
     => ! [V1c: tp__ty_2Erealax_2Ereal] :
          ( ( ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V1c ) ) )
            & ( ! [V2n: tp__ty_2Enum_2Enum] :
                  ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V2n ) ) )
                 != fo__c_2Eextreal_2ENegInf )
              | ! [V3n: tp__ty_2Enum_2Enum] :
                  ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V3n ) ) )
                 != fo__c_2Eextreal_2EPosInf ) ) )
         => ( ( surj__ty_2Eextreal_2Eextreal
              @ ( ap @ c_2Eextreal_2Eext__suminf
                @ ( lam @ ty_2Enum_2Enum
                  @ ^ [V4n: $i] : ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1c ) ) ) @ ( ap @ V0f @ V4n ) ) ) ) )
            = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__mul @ ( ap @ c_2Eextreal_2ENormal @ ( inj__ty_2Erealax_2Ereal @ V1c ) ) ) @ ( ap @ c_2Eextreal_2Eext__suminf @ V0f ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eext__suminf__lt__infty,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
     => ( ( ! [V1n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) )
          & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eext__suminf @ V0f ) )
           != fo__c_2Eextreal_2EPosInf ) )
       => ! [V2n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__lt @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eext__suminf__suminf,axiom,
    ! [V0r: $i] :
      ( ( mem @ V0r @ ( arr @ ty_2Enum_2Enum @ ty_2Erealax_2Ereal ) )
     => ( ( ! [V1n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ V0r @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) )
          & ( ( surj__ty_2Eextreal_2Eextreal
              @ ( ap @ c_2Eextreal_2Eext__suminf
                @ ( lam @ ty_2Enum_2Enum
                  @ ^ [V2n: $i] : ( ap @ c_2Eextreal_2ENormal @ ( ap @ V0r @ V2n ) ) ) ) )
           != fo__c_2Eextreal_2EPosInf ) )
       => ( ( surj__ty_2Eextreal_2Eextreal
            @ ( ap @ c_2Eextreal_2Eext__suminf
              @ ( lam @ ty_2Enum_2Enum
                @ ^ [V3n: $i] : ( ap @ c_2Eextreal_2ENormal @ ( ap @ V0r @ V3n ) ) ) ) )
          = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2ENormal @ ( ap @ c_2Eseq_2Esuminf @ V0r ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eext__suminf__mono,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
     => ! [V1g: $i] :
          ( ( mem @ V1g @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
         => ( ! [V2n: tp__ty_2Enum_2Enum] :
                ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ V1g @ ( inj__ty_2Enum_2Enum @ V2n ) ) )
                 != fo__c_2Eextreal_2ENegInf )
                & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ V1g @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) ) )
           => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eext__suminf @ V1g ) ) @ ( ap @ c_2Eextreal_2Eext__suminf @ V0f ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eext__suminf__sub,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
     => ! [V1g: $i] :
          ( ( mem @ V1g @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
         => ( ( ! [V2n: tp__ty_2Enum_2Enum] :
                  ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ V1g @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) )
                  & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ V1g @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) ) )
              & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eext__suminf @ V0f ) )
               != fo__c_2Eextreal_2EPosInf ) )
           => ( ( surj__ty_2Eextreal_2Eextreal
                @ ( ap @ c_2Eextreal_2Eext__suminf
                  @ ( lam @ ty_2Enum_2Enum
                    @ ^ [V3i: $i] : ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( ap @ V0f @ V3i ) ) @ ( ap @ V1g @ V3i ) ) ) ) )
              = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__sub @ ( ap @ c_2Eextreal_2Eext__suminf @ V0f ) ) @ ( ap @ c_2Eextreal_2Eext__suminf @ V1g ) ) ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Eext__suminf__sum,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ty_2Enum_2Enum @ ty_2Eextreal_2Eextreal ) )
     => ! [V1n: tp__ty_2Enum_2Enum] :
          ( ( ! [V2n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V2n ) ) ) )
            & ! [V3m: tp__ty_2Enum_2Enum] :
                ( ( p @ ( ap @ ( ap @ c_2Earithmetic_2E_3C_3D @ ( inj__ty_2Enum_2Enum @ V1n ) ) @ ( inj__ty_2Enum_2Enum @ V3m ) ) )
               => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ V0f @ ( inj__ty_2Enum_2Enum @ V3m ) ) )
                  = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eextreal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) )
         => ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ c_2Eextreal_2Eext__suminf @ V0f ) )
            = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( c_2Eextreal_2EEXTREAL__SUM__IMAGE @ ty_2Enum_2Enum ) @ V0f ) @ ( ap @ c_2Epred__set_2Ecount @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) ) ) ) ) ).

thf(ax_thm_2Eextreal_2Eextreal__min__def,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__min @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Eextreal_2Eextreal ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ).

thf(ax_thm_2Eextreal_2Eextreal__max__def,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__max @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Eextreal_2Eextreal ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ).

thf(conj_thm_2Eextreal_2Emin__le,axiom,
    ! [V0z: tp__ty_2Eextreal_2Eextreal,V1x: tp__ty_2Eextreal_2Eextreal,V2y: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__min @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0z ) ) )
    <=> ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0z ) ) )
        | ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0z ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Emin__le1,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__min @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ).

thf(conj_thm_2Eextreal_2Emin__le2,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__min @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__min,axiom,
    ! [V0z: tp__ty_2Eextreal_2Eextreal,V1x: tp__ty_2Eextreal_2Eextreal,V2y: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0z ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__min @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) ) )
    <=> ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Emin__le2__imp,axiom,
    ! [V0x1: tp__ty_2Eextreal_2Eextreal,V1x2: tp__ty_2Eextreal_2Eextreal,V2y1: tp__ty_2Eextreal_2Eextreal,V3y2: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x1 ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y1 ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1x2 ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3y2 ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__min @ ( inj__ty_2Eextreal_2Eextreal @ V0x1 ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1x2 ) ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__min @ ( inj__ty_2Eextreal_2Eextreal @ V2y1 ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V3y2 ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Emin__refl,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__min @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
      = V0x ) ).

thf(conj_thm_2Eextreal_2Emin__comm,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] :
      ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__min @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) )
      = ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__min @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) ) ) ).

thf(conj_thm_2Eextreal_2Emin__infty,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal] :
      ( ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__min @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) )
        = V0x )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__min @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2EPosInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        = V0x )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__min @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) )
        = fo__c_2Eextreal_2ENegInf )
      & ( ( surj__ty_2Eextreal_2Eextreal @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__min @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ fo__c_2Eextreal_2ENegInf ) ) )
        = fo__c_2Eextreal_2ENegInf ) ) ).

thf(conj_thm_2Eextreal_2Ele__max,axiom,
    ! [V0z: tp__ty_2Eextreal_2Eextreal,V1x: tp__ty_2Eextreal_2Eextreal,V2y: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0z ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__max @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) ) )
    <=> ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) )
        | ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0z ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__max1,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__max @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ).

thf(conj_thm_2Eextreal_2Ele__max2,axiom,
    ! [V0x: tp__ty_2Eextreal_2Eextreal,V1y: tp__ty_2Eextreal_2Eextreal] : ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__max @ ( inj__ty_2Eextreal_2Eextreal @ V0x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V1y ) ) ) ) ).

thf(conj_thm_2Eextreal_2Emax__le,conjecture,
    ! [V0z: tp__ty_2Eextreal_2Eextreal,V1x: tp__ty_2Eextreal_2Eextreal,V2y: tp__ty_2Eextreal_2Eextreal] :
      ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__max @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0z ) ) )
    <=> ( ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V1x ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0z ) ) )
        & ( p @ ( ap @ ( ap @ c_2Eextreal_2Eextreal__le @ ( inj__ty_2Eextreal_2Eextreal @ V2y ) ) @ ( inj__ty_2Eextreal_2Eextreal @ V0z ) ) ) ) ) ).

%------------------------------------------------------------------------------
